/*
 * Created on Aug 11, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client;

/**
 * Defines the list of user/application preference keys used by the content component.
 * 
 * @author Vijay Silva
 */
public final class PreferenceKeys {

	/*
	 * Cannot instantiate this final class
	 */
	private PreferenceKeys() {
	}

	/**
	 * The application preference key for the specification to use within the content component
	 */
	public static final String SPECIFICATION_NAME = "ContentComponent.Specification";

	/**
	 * The application preference key for the refresh rate (in seconds) at which to auto-refresh the
	 * history tab of the title view
	 */
	public static final String TITLEVIEW_HISTORY_REFRESH_RATE = "ContentComponent.TitleView.HistoryRefreshRate";

	/**
	 * The application preference key for the refresh rate (in seconds) at which to auto-refresh the
	 * sites tab of the title view
	 */
	public static final String TITLEVIEW_SITES_REFRESH_RATE = "ContentComponent.TitleView.SitesRefreshRate";

	/**
	 * The application preference key for the refresh rate (in seconds) at which to auto-refresh the
	 * activity tab of the title view
	 */
	public static final String TITLEVIEW_ACTIVITY_REFRESH_RATE = "ContentComponent.TitleView.ActivityRefreshRate";

	/**
	 * The application preference key for the sites feature, sites tab of the title view will be
	 * enabled if set to true
	 */
	public static final String SITES_FEATURE_ACTIVE = "ContentComponent.SitesFeatureActive";

	/**
	 * The preference key for the refresh rate (in milliseconds) for all portlets
	 */
	public static final String PORTLET_REFRESH_RATE = "ContentComponent.portlets.refreshRate";

	/**
	 * The preference key for the number of records to show in the activity portlet
	 */
	public static final String ACTIVITY_PORTLET_RECORD_COUNT = "ContentComponent.portlets.activityPortlet.recordCount";
	
	/**
	 * The preference key for Image Asset Types
	 */
	public static final String IMAGE_ASSET_TYPES = "ContentComponent.imageAssetTypes";

	/**
	 * The preference key for Video Asset Types
	 */
	public static final String VIDEO_ASSET_TYPES = "ContentComponent.videoAssetTypes";
}
