package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.AssetTreeItemWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * A view to display asset properties, such as cardinality, etc.
 * @author eyevkar
 */
public class AssetPropertiesView extends Composite 
{
	private static final String TXT_BTN_ENABLE = "Enable this Asset";
	private static final String TXT_BTN_DISABLE = "Disable this Asset";
	private static final String TXT_LBL_ENABLED = "Enabled";
	private static final String TXT_LBL_DISABLED = "Disabled";

	private static final String ERROR_STYLE = "WidgetValidationError";
	
	private IAssetPropertiesController controller;
	
	private SimpleContainer rootContainer;

	private TextBox txtName; 

	private TextBox txtMin;
	private TextBox txtMax;
	private TextBox txtBatchMin;
	private TextBox txtBatchMax;
	
	private CheckBox cbRequiresFile;
	private CheckBox cbHideFileView;

	private Button btnDisable;
	private TextBox txtStatus;
	
	// Asset being shown by this view 
	private UIContentClassAsset currentAsset;
	// Tree item from asset tree panel being shown by this view. Could be modified by enable/disable asset code.
	private TreeItem currentTreeItem;
	
	/**
	 * Constructor
	 */
	public AssetPropertiesView() 
	{
		rootContainer = new SimpleContainer();
		this.initWidget(rootContainer);
		
		FlexTable table = new FlexTable();
		table.addStyleName("FormPanel");
		table.addStyleName("FormFieldTable");
		
		int row = 0;
		// Name
		txtName = new TextBox();
		txtName.setEnabled(false);
		table.setWidget(row, 0, new Label("Asset Name"));
		table.setWidget(row, 1, txtName);
		row++;

		// Cardinality
		txtMin = new TextBox();
		txtMin.setMaxLength(10);
		txtMin.setTitle("Enter an integer value greater than or equal to 0.");
		txtMin.addValueChangeHandler(new ValueChangeHandler<String>() 
		{
			@Override
			public void onValueChange(ValueChangeEvent<String> event) 
			{
				if(currentAsset != null) 
				{
					String val = txtMin.getValue().trim();
					try
					{
						currentAsset.min = Integer.parseInt(val);
						
						// Error
						if(currentAsset.min < 0)
						{
							currentAsset.strMin = val;
							txtMin.addStyleName(ERROR_STYLE);
						}
						// No error
						else
						{
							currentAsset.strMin = null;
							txtMin.removeStyleName(ERROR_STYLE);
						}
					}
					catch(Exception ex)
					{
						currentAsset.strMin = val;
						txtMin.addStyleName(ERROR_STYLE);
					}
				}
			}
		});
		
		txtMax = new TextBox();
		txtMax.setMaxLength(10);
		txtMax.setTitle("Enter an integer value greater than or equal to 1.");
		txtMax.addValueChangeHandler(new ValueChangeHandler<String>() 
		{
			@Override
			public void onValueChange(ValueChangeEvent<String> event) 
			{
				if(currentAsset != null) 
				{
					String val = txtMax.getValue().trim();
					try
					{
						currentAsset.max = Integer.parseInt(val);
						
						// Error
						if(currentAsset.max < 1)
						{
							currentAsset.strMax = val;
							txtMax.addStyleName(ERROR_STYLE);
						}
						// No error
						else
						{
							currentAsset.strMax = null;
							txtMax.removeStyleName(ERROR_STYLE);
						}
					}
					catch(Exception ex)
					{
						currentAsset.strMax = val;
						txtMax.addStyleName(ERROR_STYLE);
					}
				}
			}
		});
		
		table.setWidget(row, 0, new Label("Min Occurrence"));
		table.setWidget(row, 1, txtMin);
		row++;
		table.setWidget(row, 0, new Label("Max Occurrence"));
		table.setWidget(row, 1, txtMax);
		row++;

		// Batch Cardinality
		txtBatchMin = new TextBox();
		txtBatchMin.setMaxLength(10);
		txtBatchMin.setTitle("Enter an integer value greater than or equal to 0.");
		txtBatchMin.addValueChangeHandler(new ValueChangeHandler<String>() 
		{
			@Override
			public void onValueChange(ValueChangeEvent<String> event) 
			{
				if(currentAsset != null) 
				{
					String val = txtBatchMin.getValue().trim();
					try
					{
						currentAsset.batchMin = Integer.parseInt(val);
						
						// Error
						if(currentAsset.batchMin < 0)
						{
							currentAsset.strBatchMin = val;
							txtBatchMin.addStyleName(ERROR_STYLE);
						}
						// No error
						else
						{
							currentAsset.strBatchMin = null;
							txtBatchMin.removeStyleName(ERROR_STYLE);
						}
					}
					catch(Exception ex)
					{
						currentAsset.strBatchMin = val;
						txtBatchMin.addStyleName(ERROR_STYLE);
					}
				}
			}
		});
		
		txtBatchMax = new TextBox();
		txtBatchMax.setMaxLength(10);
		txtBatchMax.setTitle("Enter an integer value greater than or equal to 0.");
		txtBatchMax.addValueChangeHandler(new ValueChangeHandler<String>() 
		{
			@Override
			public void onValueChange(ValueChangeEvent<String> event) 
			{
				if(currentAsset != null) 
				{
					String val = txtBatchMax.getValue().trim();
					try
					{
						currentAsset.batchMax = Integer.parseInt(val);
						
						// Error
						if(currentAsset.batchMax < 0)
						{
							currentAsset.strBatchMax = val;
							txtBatchMax.addStyleName(ERROR_STYLE);
						}
						// No error
						else
						{
							currentAsset.strBatchMax = null;
							txtBatchMax.removeStyleName(ERROR_STYLE);
						}
					}
					catch(Exception ex)
					{
						currentAsset.strBatchMax = val;
						txtBatchMax.addStyleName(ERROR_STYLE);
					}
				}
			}
		});
		
		table.setWidget(row, 0, new Label("Min Batch Occurrence"));
		table.setWidget(row, 1, txtBatchMin);
		row++;
		table.setWidget(row, 0, new Label("Max Batch Occurrence"));
		table.setWidget(row, 1, txtBatchMax);
		row++;
		
		cbRequiresFile = new CheckBox();
		cbRequiresFile.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			@Override
			public void onValueChange(ValueChangeEvent<Boolean> event) {
				if(currentAsset != null) {
					currentAsset.setRequiresFile(cbRequiresFile.getValue());
				}
			}
		});
		
		table.setWidget(row, 0, new Label("Requires a File"));
		table.setWidget(row, 1, cbRequiresFile);
		row++;
		
		cbHideFileView = new CheckBox();
		cbHideFileView.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			@Override
			public void onValueChange(ValueChangeEvent<Boolean> event) {
				if(currentAsset != null) {
					currentAsset.setHideFileView(cbHideFileView.getValue());
				}
			}
		});

		table.setWidget(row, 0, new Label("Hide File View"));
		table.setWidget(row, 1, cbHideFileView);
		row++;

		// Status (Enabled / Disabled)
		txtStatus = new TextBox();
		txtStatus.setEnabled(false);
		table.setWidget(row, 0, new Label("Status"));
		table.setWidget(row, 1, txtStatus);
		row++;

		btnDisable = new Button();
		btnDisable.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		btnDisable.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) {
				onDisableEnable();
			} 
		});
		
		table.setWidget(row, 0, new Label(""));
		table.setWidget(row, 1, btnDisable);
		row++;
		
		rootContainer.setWidget(table);
	}
	
	private void onDisableEnable() {
		if(currentAsset.isDisabled()) {
			// Update model
			currentAsset.setDisabled(false);
			// Update view
			enableView();
		}
		else {
			// Update model
			currentAsset.setDisabled(true);
			// Update view
			disableView();
		}
	}
	
	private void enableView() {
		// Update status and button labels
		btnDisable.setText(TXT_BTN_DISABLE);
		// Disable for the root
		btnDisable.setEnabled(!currentAsset.isRoot());
		txtStatus.setValue(TXT_LBL_ENABLED);
		
		// Enable fields
		txtMin.setEnabled(!currentAsset.isRoot());
		txtMax.setEnabled(!currentAsset.isRoot());
		
		txtBatchMin.setEnabled(currentAsset.canBatchEdit());
		txtBatchMax.setEnabled(currentAsset.canBatchEdit());
		
		cbRequiresFile.setEnabled(currentAsset.canHaveFile());
		cbHideFileView.setEnabled(currentAsset.canHaveFile());

		// Update tree item icon in the asset tree
		Widget widget = currentTreeItem.getWidget();
		if(widget instanceof AssetTreeItemWidget) {
			((AssetTreeItemWidget)widget).enable();
		}
		
		if(controller != null) {
			controller.onEnableAsset(currentAsset);
		}		
	}
	
	private void disableView() {
		// Update status and button labels
		btnDisable.setText(TXT_BTN_ENABLE);
		btnDisable.setEnabled(true);
		txtStatus.setValue(TXT_LBL_DISABLED);

		// Disable fields
		txtMin.setEnabled(false);
		txtMax.setEnabled(false);
		
		txtBatchMin.setEnabled(false);
		txtBatchMax.setEnabled(false);
		
		cbRequiresFile.setEnabled(false);
		cbHideFileView.setEnabled(false);

		// Update tree item icon in the asset tree
		Widget widget = currentTreeItem.getWidget();
		if(widget instanceof AssetTreeItemWidget) {
			((AssetTreeItemWidget)widget).disable();
		}

		if(controller != null) {
			controller.onDisableAsset(currentAsset);
		}
	}
	
	public void refresh(UIContentClassAsset asset, TreeItem item) {
		this.currentAsset = asset;
		this.currentTreeItem = item;
		
		if(asset == null) {
			disableAll();
		}
		else 
		{
			txtName.setValue(asset.getDisplayName());
			
			txtMin.setValue(asset.getMinForUI());
			if(asset.strMin != null)
			{
				txtMin.addStyleName(ERROR_STYLE);
			}
			else
			{
				txtMin.removeStyleName(ERROR_STYLE);
			}
			
			txtMax.setValue(asset.getMaxForUI());
			if(asset.strMax != null)
			{
				txtMax.addStyleName(ERROR_STYLE);
			}
			else
			{
				txtMax.removeStyleName(ERROR_STYLE);
			}
						
			txtBatchMin.setValue(asset.getBatchMinForUI());
			if(asset.strBatchMin != null)
			{
				txtBatchMin.addStyleName(ERROR_STYLE);
			}
			else
			{
				txtBatchMin.removeStyleName(ERROR_STYLE);
			}
			
			txtBatchMax.setValue(asset.getBatchMaxForUI());
			if(asset.strBatchMax != null)
			{
				txtBatchMax.addStyleName(ERROR_STYLE);
			}
			else
			{
				txtBatchMax.removeStyleName(ERROR_STYLE);
			}

			// File flags
			cbRequiresFile.setValue(asset.isRequiresFile());
			cbHideFileView.setValue(asset.isHideFileView());
			
			// Enable / Disable asset
			if(asset.isDisabled()) 
			{
				disableView();
			}
			else 
			{
				enableView();
			}
		}
	}
	
	public void disableAll() {
		disableView();
		btnDisable.setEnabled(false);
	}
	
	private static int parseInt(String str) {
		if(str == null) return 0;
		str = str.trim();
		try {
			return Integer.parseInt(str);
		}
		catch(Exception ex) {
			return 0;
		}
	}

	public void setController(IAssetPropertiesController controller) {
		this.controller = controller;
	}

	public UIContentClassAsset getCurrentAsset() {
		return currentAsset;
	}
	
}
