package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;


/**
 * Lazily loads Content Class screen
 * @author eyevkar
 */
public class ContentClassLazyView extends LazyView {
	private ContentClassView view;
	private IContentClassController controller;
	
	/**
	 * Constructor
	 */
	public ContentClassLazyView() {
	}
	
	@Override
	protected void setWidgetAnchor(String anchor) {
		if(anchor != null) {
			if(anchor.equals("New")) {
				controller.getNewContentClass();
				return;
			}
			else if(anchor.startsWith("Edit.")) {
				long id = 0;
				// Parse anchor to get content class id. Format is Edit.123, where 123 is an ID.
				try {
					String strId = anchor.substring(5);
					id = Long.parseLong(strId);
				}
				catch(Exception ex) {
				}

				controller.getContentClass(id);
				return;
			}
			else if(anchor.startsWith("EditPartner.")) {
				long contentClassId = 0;
				long partnerId = 0;
				// Parse anchor to get content class ID and partner ID. Format is EditPartner.123.567, 
				// where 123 is the content class ID and 567 is the partner ID.
				try {
					String params = anchor.substring(12);
					if(params != null) {
						String ss[] = params.split("[.]");
						contentClassId = Long.parseLong(ss[0]);
						partnerId = Long.parseLong(ss[1]);
					}
				}
				catch(Exception ex) {
				}

				controller.getContentClassPartner(contentClassId, partnerId);
				return;
			}
		}
		
		controller.getContentClassList();
	}

	@Override
	protected Widget createWidget() {
		view = new ContentClassView();
		
		// Circular reference!
		controller = new ContentClassController(view);
		view.setController(controller);
		
		return view;
	}

	@Override
	public String getAnchor() {
		return null;
	}
}
