package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.content.client.bundle.ContentClassConstants;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * Main tab in Edit Content Class screen
 * @author eyevkar
 */
public class ContentClassMainView extends Composite 
{
	private ContentClassConstants constants = GWT.create(ContentClassConstants.class);
	
	private static final int NAME_LENGTH = 24;
	private static final int DESCRIPTION_LENGTH = 254;
	
	private SimpleContainer rootContainer;
	
	private TextBox nameField;
	private TextArea descriptionField;
	private ListBox specialUsageField;
	
	/**
	 * Constructor
	 */
	public ContentClassMainView() 
	{
		// Root container
		rootContainer = new SimpleContainer();
		this.initWidget(rootContainer);
		
		// Create fields
		// Name
		nameField = new TextBox();
		nameField.setMaxLength(NAME_LENGTH);
		nameField.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> event) {
				if(event.getValue() != null) {
					nameField.setText(event.getValue().trim());
				}
			}			
		});
		
		// Description
		descriptionField = new TextArea();
		// Limit length to 255 characters
		descriptionField.addValueChangeHandler(new ValueChangeHandler<String>() 
		{
			@Override
			public void onValueChange(ValueChangeEvent<String> event) {
				String text = null;
				if(event.getValue() != null) 
				{
					text = event.getValue().trim();
				}
				
				if(text != null && text.length() >= DESCRIPTION_LENGTH) 
				{
					descriptionField.setText(text.substring(0, DESCRIPTION_LENGTH));
					/*
					if(controller != null) 
					{
						controller.showWarningMessage(constants.warningDescriptionTruncated());
					}
					*/
				}
				else 
				{
					descriptionField.setText(text);
				}
			}
		});
		
		// Special Usage
		specialUsageField = new ListBox();
		specialUsageField.addItem("None", "0");
		specialUsageField.addItem("Pre Roll", "1");
		specialUsageField.addItem("Post Roll", "2");

		// Add fields and labels to table container
		FlexTable table = new FlexTable();
		table.addStyleName("FormPanel");
		table.addStyleName("FormFieldTable");

		// Name
		table.setWidget(0, 0, new Label("Name"));
		table.setWidget(0, 1, nameField);
		// Description
		table.setWidget(1, 0, new Label("Description"));
		table.setWidget(1, 1, descriptionField);
		// Special Usage
		table.setWidget(2, 0, new Label("Special Usage"));
		table.setWidget(2, 1, specialUsageField);
		
		rootContainer.setWidget(table);
	}
	
	/**
	 * Refreshes the view with new data 
	 * @param contentClass
	 */
	public void refresh(UIContentClass contentClass, boolean isEditable) {
		if(contentClass == null) {
			nameField.setText(null);
			nameField.setEnabled(false);
			descriptionField.setText(null);
			descriptionField.setEnabled(false);
			specialUsageField.setSelectedIndex(0);
			specialUsageField.setEnabled(false);
		}
		else {
			nameField.setText(contentClass.getName());
			nameField.setEnabled(isEditable ? !contentClass.isDefault() : false);
			
			descriptionField.setText(contentClass.getDescription());
			descriptionField.setEnabled(isEditable);
			
			specialUsageField.setSelectedIndex(contentClass.getSpecialUsageId());
			specialUsageField.setEnabled((isEditable && !contentClass.isAssociatedWithTitle()) ? true : false);
		}
	}
	
	public String getName() {
		return nameField.getText();
	}

	public String getDescription() {
		return descriptionField.getText();
	}
	
	public int getSpecialUsageId() {
		return specialUsageField.getSelectedIndex();
	}
}
