package com.tandbergtv.cms.portal.content.client.contentclass;

import java.util.List;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.AssetTreeItemWidget;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassComplexFieldWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;

/**
 * Metadata asset tree and fields. 
 * Used by:
 *     Content class section: Metadata tab of edit content class screen
 * @author eyevkar
 */
public class ContentClassMetadataView 
{
	private BusyIndicator busyIndicator;
	private SimplePanel assetsViewPanel;
	
	private TabContainer tabContainer;
	private AssetPropertiesView assetPropertiesView;
	private SimplePanel fieldsViewPanel;

	private boolean isEditable;
	
	private Widget fieldsViewWidget = null;

	private UIContentClass contentClass;
	
	/**
	 * Constructor
	 */
	public ContentClassMetadataView() 
	{
		busyIndicator = new BusyIndicator();

		// Asset tree panel
		assetsViewPanel = new SimplePanel();
		assetsViewPanel.addStyleName("AssetsViewPanel");

		// Root panel for Asset tab
		assetPropertiesView = new AssetPropertiesView();
		assetPropertiesView.setController(new IAssetPropertiesController() {
			@Override
			public void onDisableAsset(UIContentClassAsset asset) {
				tabContainer.getTabBar().setTabEnabled(1, false);
			}

			@Override
			public void onEnableAsset(UIContentClassAsset asset) {
				tabContainer.getTabBar().setTabEnabled(1, true);
			}
		});
		
		// Root panel for Fields tab
		fieldsViewPanel = new SimplePanel();
		fieldsViewPanel.addStyleName("FormPanel");
		
		// Tab container with two tabs: 1. Asset and 2. Fields
    	tabContainer = new TabContainer();
    	tabContainer.addStyleName("MetadataTabContainer");
		tabContainer.add(assetPropertiesView, "Asset");
		tabContainer.add(fieldsViewPanel, "Fields");
		tabContainer.selectTab(0);
		
		tabContainer.addBeforeSelectionHandler(new BeforeSelectionHandler<Integer>() {
			@Override
			public void onBeforeSelection(BeforeSelectionEvent<Integer> event) {
				// Fields tab was selected
				if(event.getItem() == 1) {
					beforeShowFieldsTab();
				}
			}
		});
		
	}


	public Widget getLeftWidget()
	{
		return assetsViewPanel;
	}

	
	public Widget getRightWidget()
	{
		return tabContainer;
	}
	
	
	private void beforeShowFieldsTab() 
	{
		// Lazy load fields panel
		if(fieldsViewWidget == null) 
		{
			busyIndicator.center();
			fieldsViewPanel.setWidget(null);
			
			Scheduler.get().scheduleDeferred(new ScheduledCommand() 
			{
				@Override
				public void execute() 
				{
					UIContentClassAsset asset = assetPropertiesView.getCurrentAsset();
					
					// Create temporary root group
					UIContentClassFieldGroup rootGroup = new UIContentClassFieldGroup();
					rootGroup.getFields().addAll(asset.getFields());
					
					fieldsViewWidget = new ContentClassComplexFieldWidget(rootGroup, isEditable, contentClass);
					fieldsViewPanel.setWidget(fieldsViewWidget);
					busyIndicator.hide();
				}
			});
		}
	}
	
	public void refresh(UIContentClass cc, boolean isEditable) 
	{
		this.contentClass = cc;
		this.isEditable = isEditable;
		
		Tree tree = new Tree();
		UIContentClassAsset rootAsset = (contentClass == null) ? null : contentClass.getRootAsset();
		TreeItem rootItem = createAssetTree(rootAsset);
		
		if(rootItem == null) 
		{
			//showError("Invalid specification");
			return;
		}

		// Expand children
		rootItem.setState(true, false);
		// Select root
		tree.setSelectedItem(rootItem);
		// Add tree model to the tree widget
		tree.addItem(rootItem);
		
		tree.addSelectionHandler(new SelectionHandler<TreeItem>() {
			@Override
			public void onSelection(SelectionEvent<TreeItem> event) {
				showAssetPanel(event.getSelectedItem());
			}
		});
		
		assetsViewPanel.setWidget(tree);

		// Show root asset.
		showAssetPanel(rootItem);
	}

	private void showAssetPanel(TreeItem item) {
		UIContentClassAsset asset = (UIContentClassAsset)item.getUserObject();
		tabContainer.selectTab(0);
		assetPropertiesView.refresh(asset, item);
		fieldsViewWidget = null;
	}
	
	public void showBusyIndicator() {
		busyIndicator.center();
	}
	
	public void hideBusyIndicator() {
		busyIndicator.hide();
	}
	
	private TreeItem createAssetTree(UIContentClassAsset rootAsset) {
		// Create root tree item
		TreeItem rootItem = createRootTreeItem(rootAsset);
		return rootItem;
	}
	
	private TreeItem createRootTreeItem(UIContentClassAsset asset) {
		TreeItem item = new TreeItem(asset.getDisplayName());
		item.setUserObject(asset);

		// If definition is a group definition, add children recursively (depth-first)
		if(asset.hasAssets()) {
			addTreeItemChildren(asset, item);
		}
		
		return item;
	}
	
	private void addTreeItemChildren(UIContentClassAsset asset, TreeItem item) {
		List<UIContentClassAsset> list = asset.getAssets();
		for(UIContentClassAsset childAsset: list) {			
			// Create child item
			TreeItem childItem = new AssetTreeItem(childAsset);
			// Add the child to the parent 
			item.addItem(childItem);
			
			// If definition is a group definition, add children recursively
			if(childAsset.hasAssets()) {
				addTreeItemChildren(childAsset, childItem);
			}
		}
	}
	
	/**
	 * Represents a tree item in asset tree.
	 * @author eyevkar
	 */
	private static class AssetTreeItem extends TreeItem {
		private static final String STYLE_TREEITEM_SELECTED = "sites-treeItem-selected";
		private static final String STYLE_TREEITEM = "sites-treeItem";

		/**
		 * Constructor
		 * @param asset
		 */
		public AssetTreeItem(UIContentClassAsset asset) {
			super();
			AssetTreeItemWidget widget = new AssetTreeItemWidget(asset.getDisplayName(), asset.isDisabled());
			widget.addStyleName(STYLE_TREEITEM);
			
			this.setWidget(widget);
			this.setUserObject(asset);
		}
		
		@Override
		public void setSelected(boolean selected) {
			super.setSelected(selected);
			if(selected) {
				getWidget().addStyleName(STYLE_TREEITEM_SELECTED);
			} else {
				getWidget().removeStyleName(STYLE_TREEITEM_SELECTED);
			}
		}
	}
}
