package com.tandbergtv.cms.portal.content.client.contentclass;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.bundle.ContentClassConstants;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.client.contentclass.model.ValidationError;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * A view to edit content class partner
 * @author eyevkar
 */
public class ContentClassPartnerEditView extends Composite 
{
	private static final String TAB_METADATA = "Metadata";
	
	private ContentClassConstants constants = GWT.create(ContentClassConstants.class);
	
	// Controller
	private IContentClassController controller;
	// Data being edited
	private UIContentClassPartner contentClassPartner;
	
	private SimpleContainer rootContainer;
	private ContentClassPartnerMetadataView metadataView;

	private HeaderPanel header;
	private ResizableContainer resizableContainer;

	/**
	 * Constructor
	 * @param controller
	 */
	public ContentClassPartnerEditView(IContentClassController pController) {
		this.controller = pController;
		
		rootContainer = new SimpleContainer();
		this.initWidget(rootContainer);
		this.addStyleName("ContentClassEditView");
		
		// Screen Ttitle
		header = new HeaderPanel("");
		
		// Message label (Successfully saved message, errors, etc.)
		
		// Metadata view
		metadataView = new ContentClassPartnerMetadataView();
		// Put metadata view into horizontal panel, to prevent it from stretching to 100% width
		resizableContainer = new ResizableContainer(metadataView.getLeftWidget(), 
				metadataView.getRightWidget(), TAB_METADATA, null);
		
		resizableContainer.addHeightOffsettingWidget(header);
		
		// Buttons
		// Save
		ButtonWidget btnSave = new ButtonWidget("Save");
		btnSave.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		btnSave.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				if(controller != null) 
				{
					controller.saveContentClassPartner(contentClassPartner);
				}
			}
		});
		resizableContainer.addButton(TAB_METADATA, btnSave);
		
		// Cancel
		ButtonWidget btnCancel = new ButtonWidget("Cancel");
		btnCancel.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		btnCancel.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				History.back();
			}
		});
		resizableContainer.addButton(TAB_METADATA, btnCancel);
		
		// Main panel
		VerticalPanel vp = new VerticalPanel();
		vp.add(header);
		vp.add(resizableContainer);
		vp.addStyleName("ContentClassPartnerMetadataView");
		
		rootContainer.setWidget(vp);
	}
	
	/**
	 * Refreshes the view with content class partner data
	 * @param ccp
	 */
	public void refresh(UIContentClassPartner ccp) 
	{
		// Clear messages
		resizableContainer.reset();
		
		this.contentClassPartner = ccp;
		header.setLabel("Edit Metadata: Partner: '" + ccp.getPartnerName() 
				+ "', Content Class: '" + ccp.getContentClassName() + "'");
		
		metadataView.refresh(ccp, true);
	}
	
	/**
	 * Get called after content class partner was successfully saved
	 */
	public void afterSave() 
	{
		resizableContainer.setInfoMessage(constants.ccPartnerSaved());
	}

	public void onError(ContentClassCommand cmd, String message) 
	{
		resizableContainer.setErrorMessage(message);
	}

	public void onError(List<ValidationError> errors) 
	{
		if(errors == null || errors.isEmpty()) return;
		
		StringBuilder bld = new StringBuilder();
		bld.append("<p>Please fix the following validation errors before saving:</p>");
		bld.append("<ul>");
		
		for(int i = 0; i < errors.size(); i++) 
		{
			bld.append("<li>");
			ValidationError error = errors.get(i);
			
			if(error.getField() != null)
			{
				bld.append(error.getField().getDisplayName());
				bld.append(" ");
			}
			
			bld.append("[");
			bld.append(error.getAsset().getDisplayName());
			bld.append("]: ");
			bld.append(error.getMessage());
			
			bld.append("</li>");
		}
		bld.append("</ul>");
		
		resizableContainer.setErrorHTML(bld.toString());
	}

}
