package com.tandbergtv.cms.portal.content.client.contentclass;

import java.util.List;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassFieldWidget;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassFieldWidget.Type;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;


/**
 * Displays content class partner metadata: asset tree and list of fields for each asset.
 * @author eyevkar
 */
public class ContentClassPartnerMetadataView 
{
	private BusyIndicator busyIndicator;
	private TabContainer tabContainer;
	
	private SimplePanel assetsViewPanel;
	private SimplePanel fieldsViewPanel;

	private boolean isEditable;

	/**
	 * Constructor
	 */
	public ContentClassPartnerMetadataView() 
	{
		busyIndicator = new BusyIndicator();
		
		assetsViewPanel = new SimplePanel();
		assetsViewPanel.addStyleName("AssetsViewPanel");

		fieldsViewPanel = new SimplePanel();
		fieldsViewPanel.addStyleName("FormPanel");

		// Tab container with two tabs: 1. Asset and 2. Fields
    	tabContainer = new TabContainer();
    	tabContainer.addStyleName("MetadataTabContainer");
		tabContainer.add(fieldsViewPanel, "Fields");
		tabContainer.selectTab(0);
	}

	
	public Widget getLeftWidget()
	{
		return assetsViewPanel;
	}

	
	public Widget getRightWidget()
	{
		return tabContainer;
	}
	
	
	public void refresh(final UIContentClassPartner ccp, boolean isEditable) {
		this.isEditable = isEditable;
		
		Tree tree = new Tree();
		
		UIContentClassAsset rootAsset = (ccp == null) ? null : ccp.getRootAsset();
		TreeItem rootItem = createAssetTree(rootAsset);
		
		if(rootItem == null) {
			//showError("Invalid specification");
			return;
		}

		// Expand children
		rootItem.setState(true, false);
		// Select root
		tree.setSelectedItem(rootItem);
		// Add tree model to the tree widget
		tree.addItem(rootItem);
		
		tree.addSelectionHandler(new SelectionHandler<TreeItem>() {
			@Override
			public void onSelection(SelectionEvent<TreeItem> event) {
				showAssetPanel(event.getSelectedItem());
			}
		});
		
		assetsViewPanel.setWidget(tree);

		// Show root asset.
		showAssetPanel(rootItem);
	}

	private void showAssetPanel(TreeItem item) {
		UIContentClassAsset asset = (UIContentClassAsset)item.getUserObject();
		showAssetPanel(asset);
	}
	
	private void showAssetPanel(UIContentClassAsset asset) {
		// Create root group
		UIContentClassFieldGroup rootGroup = new UIContentClassFieldGroup();
		rootGroup.getFields().addAll(asset.getFields());

		Widget fieldsViewWidget = createFieldGroupWidget(asset, rootGroup);
		fieldsViewPanel.setWidget(fieldsViewWidget);
	}

	private Widget createFieldGroupWidget(UIContentClassAsset asset, UIContentClassFieldGroup group) {
		if(group == null) return new Label("No Data");

		List<UIContentClassField> fields = group.getFields();
		if(fields == null || fields.isEmpty()) return new Label("No Data");

		// Main panel
		VerticalPanel vp = new VerticalPanel();
		
		// Simple fields
		
		// Create a table
		FlexTable table = new FlexTable();
		table.addStyleName("FormFieldTable");
		
		// Add all simple fields to the table
		int row = 0;
		for(UIContentClassField field: fields) {
			if(!(field instanceof UIContentClassFieldGroup)) {
				// Skip disabled fields
				if(field.isDisabled()) continue;
				
				// Skip provider id and provider name. They could not be changed and should not be displayed in GUI.
				// if(UIContentClassMetadata.PATH_PROVIDER_ID.equals(field.getPath())) continue;
				// if(UIContentClassMetadata.PATH_PROVIDER_NAME.equals(field.getPath())) continue;

				// Add simple field to the table
				
				// Label
				HTML label = new HTML();
				table.setWidget(row, 0, label);
				table.getCellFormatter().setAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT, HasVerticalAlignment.ALIGN_MIDDLE);
				
				// Widget
				ContentClassFieldWidget widget = new ContentClassFieldWidget(Type.ContentClassPartner, field, isEditable, null, label);
				// This call will add asterisk (*) for required fields.
				widget.setRequired(field.isRequired());
				table.setWidget(row, 1, widget);
				
				// Increment row
				row++;
			}
		}
		vp.add(table);

		// Complex fields
		for(UIContentClassField field: fields) {
			if(field instanceof UIContentClassFieldGroup) {
				// Skip disabled fields
				if(field.isDisabled()) continue;
				
				UIContentClassFieldGroup childGroup = (UIContentClassFieldGroup)field;
				RoundedDisclosureContainer rdc = new RoundedDisclosureContainer(childGroup.getDisplayName());
				Widget groupWidget = createFieldGroupWidget(asset, childGroup);
				rdc.setContent(groupWidget);
				rdc.addStyleName("ContentClassComplexFieldWidget");
				vp.add(rdc);
			}
		}
		
		return vp;
	}
	
	public void showBusyIndicator() {
		busyIndicator.center();
	}
	
	public void hideBusyIndicator() {
		busyIndicator.hide();
	}
	
	private TreeItem createAssetTree(UIContentClassAsset rootAsset) {
		// Create root tree item
		TreeItem rootItem = createRootTreeItem(rootAsset);
		return rootItem;
	}
	
	private TreeItem createRootTreeItem(UIContentClassAsset asset) {
		TreeItem item = new TreeItem(asset.getDisplayName());
		item.setUserObject(asset);

		// If definition is a group definition, add children recursively (depth-first)
		if(asset.hasAssets()) {
			addTreeItemChildren(asset, item);
		}
		
		return item;
	}
	
	private void addTreeItemChildren(UIContentClassAsset asset, TreeItem item) {
		List<UIContentClassAsset> list = asset.getAssets();
		for(UIContentClassAsset childAsset: list) {
			// Skip disabled assets
			if(childAsset.isDisabled()) continue;
			
			// Create child item
			TreeItem childItem = new TreeItem(childAsset.getDisplayName());
			childItem.setUserObject(childAsset);
			// Add the child to the parent 
			item.addItem(childItem);
			
			// If definition is a group definition, add children recursively
			if(childAsset.hasAssets()) {
				addTreeItemChildren(childAsset, childItem);
			}
		}
	}
	
}
