package com.tandbergtv.cms.portal.content.client.contentclass;

import java.util.List;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.contentclass.model.CCPValidationError;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.client.contentclass.model.ValidationError;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * Main view which handles several content class sub-views, such as
 * list view and edit/create view. 
 * @author eyevkar
 */
public class ContentClassView extends Composite 
{
	// Controller
	private IContentClassController controller;
	
	// Root container
	private SimpleContainer rootContainer;
	private BusyIndicator busyIndicator;

	// Child views
	private ContentClassEditView editView;
	private ContentClassPartnerEditView editPartnerView;
	private ContentClassListView listView;
	private VerticalPanel emptyPanel;
	private MessageArea errorPanel;

	/**
	 * Constructor
	 */
	public ContentClassView() 
	{
		rootContainer = new SimpleContainer();
		this.initWidget(rootContainer);
		this.addStyleName("ContentClassView");
		busyIndicator = new BusyIndicator();
		
		emptyPanel = new VerticalPanel();
		errorPanel = new MessageArea();
		emptyPanel.add(errorPanel);
		rootContainer.setWidget(emptyPanel);
	}
	
	/**
	 * Sets controller
	 * @param controller
	 */
	public void setController(IContentClassController controller) {
		this.controller = controller;
	}

	/**
	 * Shows busy indicator
	 */
	public void showBusyIndicator() {
		busyIndicator.center();
	}
	
	/**
	 * Hides busy indicator
	 */
	public void hideBusyindicator() {
		busyIndicator.hide();
	}

	/**
	 * Shows empty view
	 */
	public void showEmptyView() 
	{
		errorPanel.reset();
		emptyPanel.setVisible(false);
		rootContainer.setWidget(emptyPanel);
	}
	
	/**
	 * Shows content class list
	 * @param list content class list
	 */
	public void showContentClassListView(List<UIContentClass> list) {
		// Lazily create list view
		if(listView == null) 
		{
			listView = new ContentClassListView(controller);
		}

		rootContainer.setWidget(listView);
		listView.refresh(list);
	}
	
	/**
	 * Shows new content class edit view
	 * @param contentClass
	 */
	public void showContentClassNewView(UIContentClass contentClass) {
		// Lazily create edit view
		if(editView == null) {
			editView = new ContentClassEditView(controller);
		}
		
		rootContainer.setWidget(editView);
		editView.refresh(contentClass, true);
	}
	
	/**
	 * Shows content class edit view
	 * @param contentClass
	 */
	public void showContentClassEditView(UIContentClass contentClass) {
		// Lazily create edit view
		if(editView == null) {
			editView = new ContentClassEditView(controller);
		}
		
		rootContainer.setWidget(editView);
		editView.refresh(contentClass, false);
	}

	/**
	 * Shows content class edit view
	 * @param contentClass
	 */
	public void showContentClassPartnerEditView(UIContentClassPartner ccp) {
		// Lazily create edit view
		if(editPartnerView == null) {
			editPartnerView = new ContentClassPartnerEditView(controller);
		}
		
		rootContainer.setWidget(editPartnerView);
		editPartnerView.refresh(ccp);
	}

	/**
	 * Shows etrror message
	 * @param error
	 */
	public void onError(ContentClassCommand cmd, String message) 
	{
		switch(cmd) 
		{
			case List:
			case Get:
				showEmptyView();
				errorPanel.setErrorMessage(message);
				break;
			case Save:
				if(editView != null) 
				{
					editView.onError(message);
				}
				else 
				{
					showEmptyView();
					errorPanel.setErrorMessage(message);
				}
				break;
			case GetPartner:
				showEmptyView();
				errorPanel.setErrorMessage(message);
				break;
			case SavePartner:
				if(editPartnerView != null) 
				{
					editPartnerView.onError(cmd, message);
				}
				else 
				{
					showEmptyView();
					errorPanel.setErrorMessage(message);
				}
				break;
			case Delete:
				if(listView != null) 
				{
					listView.onError(cmd, message);
				}
				else 
				{
					showEmptyView();
					errorPanel.setErrorMessage(message);
				}
				break;
			default:
				break;
		}
	}

	
	public void onError(ContentClassCommand cmd, List<ValidationError> errors) 
	{
		switch(cmd) 
		{
			case Save:
				if(editView != null) 
				{
					editView.onError(errors);
				}
				else 
				{
					showEmptyView();
				}
				break;
			case SavePartner:
				if(editPartnerView != null) 
				{
					editPartnerView.onError(errors);
				}
				else 
				{
					showEmptyView();
				}
				break;
			default:
				break;
		}
	}

	public void onCCPError(List<CCPValidationError> errors) 
	{
		if(editView != null) 
		{
			editView.onCCPError(errors);
		}
		else 
		{
			showEmptyView();
		}
	}
	
	
	/**
	 * Get called after content class was successfully saved 
	 * @param id
	 */
	public void onAfterContentClassSave(long id) {
		editView.afterSave(id);
	}
	
	/**
	 * Get called after content class partner was successfully saved 
	 */
	public void onAfterContentClassPartnerSave() {
		editPartnerView.afterSave();
	}
	
}
