package com.tandbergtv.cms.portal.content.client.contentclass.dialog;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassComplexFieldWidget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Dialog to edit complex field properties
 * @author eyevkar
 */
public class ComplexFieldPropertiesDialog extends DialogBox {
	private static final String TIP_MIN = "Enter positive integer from 1 to 99. Leave the field blank to use default (1) value.";
	private static final String TIP_MAX = "Enter positive integer from 1 to 99. Leave the field blank to use default (unlimited) value.";
	private static final String ERROR_STYLE = "WidgetValidationError";
	
	private ContentClassComplexFieldWidget widget;

	private TextBox txtName;
	private TextBox txtDataType;
	
	private TextBox txtMin;
	boolean minIsValid = true;

	private TextBox txtMax;
	boolean maxIsValid = true;
	
	private Button btnSave;

	
	public ComplexFieldPropertiesDialog(final ContentClassComplexFieldWidget widget) {
		super();
		
		this.widget = widget;
		this.addStyleName("FieldPropertiesDialog");
		
		setModal(true);
		// Dialog box's caption
	    setText("Properties");
	    //setAnimationEnabled(true);
	    setGlassEnabled(true);
	    
	    VerticalPanel rootPanel = new VerticalPanel();
	    // Main view
	    Panel mainView = createMainView();
	    rootPanel.add(mainView);
	    
	    // Buttons
	    Widget buttonPanel = createButtonPanel();
	    rootPanel.add(buttonPanel);

	    // Refresh UI with data
	    refresh();
	    
	    setWidget(rootPanel);
	}

	private Panel createMainView() {
		SimplePanel panel = new SimplePanel();
		panel.addStyleName("ContentClassEditView");
		
		if(widget == null || widget.getGroup() == null) return panel;
		
		FlexTable table = new FlexTable();
		table.addStyleName("FormPanel");
		table.addStyleName("FormFieldTable");
		
		int row = 0;
		// Name
		txtName = new TextBox();
		txtName.setEnabled(false);
		table.setWidget(row, 0, new Label("Field Name"));
		table.setWidget(row, 1, txtName);
		row++;
		
		// Type
		txtDataType = new TextBox();
		txtDataType.setEnabled(false);
		txtDataType.setValue("COMPLEX");
		table.setWidget(row, 0, new Label("Data Type"));
		table.setWidget(row, 1, txtDataType);
		row++;
		
		// Cardinality
		// Min
		txtMin = new TextBox();
		txtMin.setMaxLength(2);
		txtMin.setTitle(TIP_MIN);
		txtMin.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> event) {
				Widget widget = (Widget)event.getSource();
				String value = trim(event.getValue());
				
				if(!isEmpty(value))
				{
					Integer iVal = parseInt(value);
					if(iVal == null || iVal < 1) {
						widget.addStyleName(ERROR_STYLE);
						minIsValid = false;
						return;
					}
				}
				
				widget.removeStyleName(ERROR_STYLE);
				minIsValid = true;
			}
		});
		
		table.setWidget(row, 0, new Label("Min Occurrence"));
		table.setWidget(row, 1, txtMin);
		row++;
		
		// Max
		txtMax = new TextBox();
		txtMax.setMaxLength(2);
		txtMax.setTitle(TIP_MAX);
		txtMax.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> event) {
				Widget widget = (Widget)event.getSource();
				String value = trim(event.getValue());
				
				if(!isEmpty(value))
				{
					Integer iVal = parseInt(value);
					if(iVal == null || iVal < 1) {
						widget.addStyleName(ERROR_STYLE);
						maxIsValid = false;
						return;
					}
				}
				
				widget.removeStyleName(ERROR_STYLE);
				maxIsValid = true;
			}
		});
		
		table.setWidget(row, 0, new Label("Max Occurrence"));
		table.setWidget(row, 1, txtMax);
		row++;
		
		panel.add(table);
		return panel;
	}
	
	private Widget createButtonPanel() 
	{
	    // Buttons
	    // Save
	    btnSave = new Button("Save");
	    btnSave.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
	    btnSave.addClickHandler(new ClickHandler() 
	    {
	    	public void onClick(ClickEvent event) 
	    	{
	    		onSave();
	        }
	    });
	    
	    // Cancel
	    Button btnCancel = new Button("Cancel");
	    btnCancel.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
	    btnCancel.addClickHandler(new ClickHandler() 
	    {
	    	public void onClick(ClickEvent event) 
	    	{
	    		onCancel();
	        }
	    });

	    // Button panel
	    HorizontalPanel buttonPanel = new HorizontalPanel();
	    buttonPanel.addStyleName("ButtonPanel");
	    buttonPanel.add(btnSave);
	    buttonPanel.add(btnCancel);
	    return buttonPanel;
	}

	private boolean validate() {
		if(!minIsValid) return false;
		if(!maxIsValid) return false;
		
		return true;
	}
	
	private void onSave() {
		if(!validate()) {
			return;
		}
		
		// Set values
		UIContentClassFieldGroup uiField = widget.getGroup();
		uiField.setMin(parseInt(txtMin.getValue()));
		uiField.setMax(parseInt(txtMax.getValue()));
		
		// Hide the dialog
		this.hide();
	}
	
	private void onCancel() {
		// Hide the dialog
		this.hide();
	}

	private void refresh() 
	{
		if(widget == null) return;
		UIContentClassField field = widget.getGroup();
		if(field == null) return;
	
		boolean canSave = ClientAuthorizationManager.isAuthorized(Permissions.CONTENT_CLASS_VIEW, Permissions.CONTENT_CLASS_MODIFY);
		btnSave.setEnabled(canSave);
		
		txtName.setValue(field.getDisplayName());
		
		// Cardinality
		if(field.isMultiValue()) {
			txtMin.setValue(field.getMin() == null ? "" : String.valueOf(field.getMin()));
			txtMax.setValue(field.getMax() == null ? "" : String.valueOf(field.getMax()));
		}
	}	
	
	private static Integer parseInt(String str) {
		if(str == null) return null;
		str = str.trim();
		try {
			return Integer.parseInt(str);
		}
		catch(Exception ex) {
			return null;
		}
	}

	private static String trim(String str) {
		return (str == null) ? null : str.trim();
	}
	
	private static boolean isEmpty(String str)
	{
		return (str == null || str.length() < 1);
	}
	
}
