package com.tandbergtv.cms.portal.content.client.contentclass.dialog;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class EditOptionDialog extends DialogBox 
{
	private static final String STYLE_ERROR = "CCPopupError";

	private IEditOptionDialogListener listener;

	private Label lblMessage;
	
	private TextBox txtValue;
	private TextBox txtDisplayName;
	private Button btnSave;


	public EditOptionDialog(IEditOptionDialogListener listener) 
	{
		super();
		this.listener = listener;
		
		this.addStyleName("FieldPropertiesDialog");
		
		setModal(true);
		// Dialog box's caption
	    setText("Edit Option");
	    //setAnimationEnabled(true);
	    setGlassEnabled(true);
	    
	    VerticalPanel rootPanel = new VerticalPanel();
	    
	    // Error message label
	    lblMessage = new Label();
	    lblMessage.setVisible(false);
	    lblMessage.addStyleName(STYLE_ERROR);
	    rootPanel.add(lblMessage);
	    
	    // Options
	    Panel editView = createEditView();
	    rootPanel.add(editView);
	    
	    // Buttons
	    Widget buttonPanel = createButtonPanel();
	    rootPanel.add(buttonPanel);

	    setWidget(rootPanel);		
	}

	private Panel createEditView()
	{
		SimplePanel panel = new SimplePanel();
		panel.addStyleName("ContentClassEditView");
		
		FlexTable table = new FlexTable();
		table.addStyleName("FormPanel");
		table.addStyleName("FormFieldTable");
		
		int row = 0;
		// Value
		txtValue = new TextBox();
		table.setWidget(row, 0, new Label("Value"));
		table.setWidget(row, 1, txtValue);
		row++;
		// Display Name
		txtDisplayName = new TextBox();
		table.setWidget(row, 0, new Label("Display Name"));
		table.setWidget(row, 1, txtDisplayName);
		row++;
		
		panel.add(table);
		return panel;		
	}
	
	private Widget createButtonPanel() 
	{
	    // Buttons
	    // Save
	    btnSave = new Button("Save");
	    btnSave.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
	    btnSave.addClickHandler(new ClickHandler() 
	    {
	    	public void onClick(ClickEvent event) 
	    	{
	    		onSave();
	        }
	    });
	    
	    // Cancel
	    Button btnCancel = new Button("Cancel");
	    btnCancel.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
	    btnCancel.addClickHandler(new ClickHandler() 
	    {
	    	public void onClick(ClickEvent event) 
	    	{
	    		onCancel();
	        }
	    });

	    // Button panel
	    HorizontalPanel buttonPanel = new HorizontalPanel();
	    buttonPanel.addStyleName("ButtonPanel");
	    buttonPanel.add(btnSave);
	    buttonPanel.add(btnCancel);
	    return buttonPanel;
	}

	private void showError(String msg)
	{
		lblMessage.setText(msg);
		lblMessage.setVisible(true);
	}
	
	private void hideError()
	{
		lblMessage.setVisible(false);
	}
	
	
	private void onSave() 
	{
		if(listener != null) 
		{
			String validationError = listener.onSave(txtValue.getText(), txtDisplayName.getText());
			if(validationError != null)
			{
				showError(validationError);
				return;
			}
			else
			{
				hideError();
			}
		}
		
		// Hide the dialog
		this.hide();
	}
	
	private void onCancel() {
		// Hide the dialog
		this.hide();
	}

	/**
	 * Edit existing option
	 * @param value
	 * @param displayName
	 */
	public void refresh(String value, String displayName)
	{
		boolean canSave = ClientAuthorizationManager.isAuthorized(Permissions.CONTENT_CLASS_VIEW, Permissions.CONTENT_CLASS_MODIFY);
		btnSave.setEnabled(canSave);
		
		setText("Edit Option");
		txtValue.setText(value);
		txtDisplayName.setText(displayName);
	}

	
	/**
	 * Add new option
	 */
	public void refresh()
	{
		boolean canSave = ClientAuthorizationManager.isAuthorized(Permissions.CONTENT_CLASS_VIEW, Permissions.CONTENT_CLASS_MODIFY);
		btnSave.setEnabled(canSave);

		setText("Add Option");
		txtValue.setText("");
		txtDisplayName.setText("");
	}

}
