package com.tandbergtv.cms.portal.content.client.contentclass.dialog;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassFieldWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Edit options dialog. 
 * Used by content class partner screen to edit options in a drop down boxes.
 * NOTE: Global content class screen uses FieldPropertiesDialog instead. 
 * @author eyevkar
 */
public class PartnerFieldPropertiesDialog extends DialogBox {
	private ContentClassFieldWidget widget;

	private FlexTable optionTable;
	
	/**
	 * Constructor
	 */
	public PartnerFieldPropertiesDialog(final ContentClassFieldWidget widget) {
		super();
		
		this.widget = widget;
		this.addStyleName("FieldPropertiesDialog");
		
		setModal(true);
		// Dialog box's caption
	    setText("Options");
	    //setAnimationEnabled(true);
	    setGlassEnabled(true);
	    
	    VerticalPanel rootPanel = new VerticalPanel();

	    // Options
	    Panel optionsView = createOptionsView();
	    rootPanel.add(optionsView);
	    
	    // Buttons
	    Widget buttonPanel = createButtonPanel();
	    rootPanel.add(buttonPanel);

	    // Refresh UI with data
	    refresh();
	    
	    setWidget(rootPanel);
	}

	private Panel createOptionsView() {
	    // Main content panel
	    VerticalPanel contentPanel = new VerticalPanel();
	    contentPanel.addStyleName("Content");
	    
	    // Options table
	    createOptionTable();
	    
	    // Panel with options table
	    VerticalPanel formPanel = new VerticalPanel();
	    formPanel.addStyleName("FormFieldTable");
	    formPanel.add(optionTable);
	    
	    contentPanel.add(formPanel);
	    
	    return contentPanel;
	}
	
	private void createOptionTable() {
	    // Create table header
	    optionTable = new FlexTable();
	    optionTable.addStyleName("portletTable");
	}
	
	private Widget createButtonPanel() {
	    // Buttons
	    // Save
	    Button btnSave = new Button("Save");
	    btnSave.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
	    btnSave.addClickHandler(new ClickHandler() 
	    {
	    	public void onClick(ClickEvent event) 
	    	{
	    		onSave();
	        }
	    });
	    
	    // Cancel
	    Button btnCancel = new Button("Cancel");
	    btnCancel.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
	    btnCancel.addClickHandler(new ClickHandler() 
	    {
	    	public void onClick(ClickEvent event) 
	    	{
	    		onCancel();
	        }
	    });

	    // Button panel
	    HorizontalPanel buttonPanel = new HorizontalPanel();
	    buttonPanel.addStyleName("ButtonPanel");
	    buttonPanel.add(btnSave);
	    buttonPanel.add(btnCancel);
	    return buttonPanel;
	}

	private void onSave() {
		setOptions();
		// Hide the dialog
		this.hide();
	}
	
	private void onCancel() {
		// Hide the dialog
		this.hide();
	}

	private void setOptions() 
	{
		Set<String> filteredKeys = new HashSet<String>();
	
		for(int row = 1; row < optionTable.getRowCount(); row++) 
		{
			CheckBox cb = (CheckBox)optionTable.getWidget(row, 0);
			Label lblValue = (Label)optionTable.getWidget(row, 1);
			String value = lblValue.getText();
			
			// Check box is not selected. Exclude this item.
			if(cb.getValue() == false)
			{
				filteredKeys.add(value);
			}
		}

		widget.getField().setFilteredOptionKeys(filteredKeys);
		widget.refresh();
		
		// If option corresponding to old default value was disabled, set default value = null
		String oldValue = widget.getField().getValue();
		if(oldValue != null && filteredKeys.contains(oldValue))
		{
			widget.getField().setValue(null);		
		}
	}

	private void refresh() {
		if(widget == null) return;
		UIContentClassField field = widget.getField();
		if(field == null) return;
		
		optionTable.clear();
		
		// Header check box
		final CheckBox mcb = new CheckBox();
		mcb.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) 
			{
				boolean selected = mcb.getValue();
				
				for(int row = 1; row < optionTable.getRowCount(); row++) 
				{
					CheckBox cb = (CheckBox)optionTable.getWidget(row, 0);
					cb.setValue(selected);
				}
			}
		});		

		// Header
		optionTable.setWidget(0, 0, mcb);
		optionTable.setWidget(0, 1, new Label("Value"));
		optionTable.setWidget(0, 2, new Label("Display Name"));
		
		// Set CSS styles
		for(int i = 0; i <= 2; i++) {
			optionTable.getCellFormatter().setStyleName(0, i, "portlet-tableHeader");
		}
	    
	    // Data
	    List<KeyValuePair> list = field.getOptions();
	    // Elements to be excluded from list of options in edit title screen
	    Set<String> excludedItems = field.getFilteredOptionKeys(); 
	    
	    int row = 1;
	    for(KeyValuePair kvp: list) 
	    {
	    	CheckBox cb = new CheckBox();
		    // If this item is not in the list of excluded items, select it
	    	if(excludedItems == null || !excludedItems.contains(kvp.getValue())) {
	    		cb.setValue(true);
	    	}
	    	
	    	optionTable.setWidget(row, 0, cb);
		    optionTable.setWidget(row, 1, new Label(kvp.getValue()));
		    optionTable.setWidget(row, 2, new Label(kvp.getKey()));
		    
		    // Set CSS styles
			for(int i = 0; i <= 2; i++) {
				optionTable.getCellFormatter().setStyleName(row, i, "portlet-table-text");
			}
		    
	    	++row;
	    }

	}
	
}
