package com.tandbergtv.cms.portal.content.client.contentclass.model;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;


/**
 * UI model for Content Class
 * @author eyevkar
 */
public class UIContentClass implements IsSerializable, Comparable<UIContentClass> 
{
	public static final int TYPE_PACKAGE = 0;
	public static final int TYPE_SERIES = 1;
	public static final int TYPE_CATEGORY = 2;
	
	private long id;
	private int typeId; 	// 0 - Package, 1 - Series, 2 - Category
	
	private String name;
	private String description;
	private int specialUsageId;
	private boolean isDefault;
	private boolean isAssociatedWithTitle;
	private UIContentClassAsset rootAsset;
	// Key = provider java class; Value = display name
	private List<KeyValuePair> autofillProviders;

	/**
	 * Constructor
	 */
	public UIContentClass() {
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public int getTypeId() {
		return typeId;
	}

	public void setTypeId(int typeId) {
		this.typeId = typeId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getSpecialUsageId() {
		return specialUsageId;
	}

	public void setSpecialUsageId(int specialUsageId) {
		this.specialUsageId = specialUsageId;
	}

	public UIContentClassAsset getRootAsset() {
		return rootAsset;
	}

	public void setRootAsset(UIContentClassAsset rootAsset) {
		this.rootAsset = rootAsset;
	}

	public boolean isDefault() {
		return isDefault;
	}

	public void setDefault(boolean isDefault) {
		this.isDefault = isDefault;
	}

	public boolean isAssociatedWithTitle() {
		return isAssociatedWithTitle;
	}

	public void setAssociatedWithTitle(boolean isAssociatedWithTitle) {
		this.isAssociatedWithTitle = isAssociatedWithTitle;
	}

	public List<KeyValuePair> getAutofillProviders() {
		return autofillProviders;
	}

	public void setAutofillProviders(List<KeyValuePair> autofillProviders) {
		this.autofillProviders = autofillProviders;
	}

	@Override
	public int compareTo(UIContentClass o) {
		if(this.isDefault()) return -1;
		if(o.isDefault()) return 1;
		return this.getName().compareTo(o.getName());
	}
	
}
