package com.tandbergtv.cms.portal.content.client.contentclass.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * UI model of a Content Class Asset
 * @author eyevkar
 */
public class UIContentClassAsset implements IsSerializable {
	/**
	 * A path to the asset (from the root), e.g. PACKAGE/TITLE or PACKAGE/MOVIE
	 */
	private String path;
	private String displayName;
	private List<UIContentClassField> fields;
	private List<UIContentClassAsset> assets;

	public int min = 1;
	public int max = 1;
	public String strMin;
	public String strMax;
	
	// Max cardinality allowed by ECMF schema
	private int maxAllowed;

	public int batchMin = 0;
	public int batchMax = 0;
	public String strBatchMin;
	public String strBatchMax;

	private boolean disabled;
	
	private boolean requiresFile;
	private boolean hideFileView;
	
	/**
	 * Default constructor. Required by GWT to serialize the object.
	 */
	public UIContentClassAsset() {
	}
	
	/**
	 * Constructor
	 * @param path
	 */
	public UIContentClassAsset(String path) {
		this.path = path;
		if("PACKAGE".equals(path) || "PACKAGE/TITLE".equals(path)) {
			min = 1;
			batchMin = 1;
			batchMax = 1;
		}
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getPath() {
		return path;
	}
	
	public List<UIContentClassField> getFields() {
		return fields;
	}

	public void setFields(List<UIContentClassField> fields) {
		this.fields = fields;
	}

	public List<UIContentClassAsset> getAssets() {
		return assets;
	}
	
	public boolean hasAssets() {
		return assets != null && !assets.isEmpty();
	}
	
	public void addAsset(UIContentClassAsset asset) {
		if(assets == null) {
			assets = new ArrayList<UIContentClassAsset>();
		}
		assets.add(asset);
	}

	public int getMin() {
		return min;
	}

	public String getMinForUI()
	{
		return (strMin != null) ? strMin : String.valueOf(min);
	}
	
	public void setMin(int min) {
		this.min = min;
	}

	public int getMax() {
		return max;
	}

	public String getMaxForUI()
	{
		return (strMax != null) ? strMax : String.valueOf(max);
	}
	
	public void setMax(int max) {
		this.max = max;
	}

	public int getMaxAllowed() {
		return maxAllowed;
	}

	public void setMaxAllowed(int maxAllowed) {
		this.maxAllowed = maxAllowed;
	}

	public int getBatchMin() {
		return batchMin;
	}

	public String getBatchMinForUI()
	{
		return (strBatchMin != null) ? strBatchMin : String.valueOf(batchMin);
	}
	
	
	public void setBatchMin(int batchMin) {
		this.batchMin = batchMin;
	}

	public int getBatchMax() {
		return batchMax;
	}

	public String getBatchMaxForUI()
	{
		return (strBatchMax != null) ? strBatchMax : String.valueOf(batchMax);
	}
	
	
	public void setBatchMax(int batchMax) {
		this.batchMax = batchMax;
	}

	public boolean isDisabled() {
		return disabled;
	}

	public void setDisabled(boolean disabled) {
		this.disabled = disabled;
		
		// Disable / enable children
		if(assets != null) {
			for(UIContentClassAsset cAsset: assets) {
				cAsset.setDisabled(disabled);
			}
		}
	}

	
	public boolean canHaveFile()
	{
		return true;
	}
	
	public boolean canBatchEdit()
	{
		if("PACKAGE".equals(path) || "PACKAGE/TITLE".equals(path)) return true;
		return false;
	}
	
	public boolean isRequiresFile() 
	{
		if(canHaveFile()) {
			return requiresFile;
		}
		else {
			return false;
		}
	}

	public void setRequiresFile(boolean requiresFile) {
		this.requiresFile = requiresFile;
	}

	public boolean isHideFileView() {
		if(canHaveFile()) {
			return hideFileView;
		}
		else {
			return true;
		}
	}

	public void setHideFileView(boolean hideFileView) {
		this.hideFileView = hideFileView;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public boolean isRoot() {
		if(path == null) return true;
		return !path.contains("/");
	}
}
