package com.tandbergtv.cms.portal.content.client.contentclass.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * A collection of fields and groups of fields.
 * @author eyevkar
 */
public class UIContentClassFieldGroup extends UIContentClassField implements IsSerializable 
{
	private List<UIContentClassField> fields;
	
	/**
	 * Default constructor. Required by GWT to serialize the object.
	 */
	public UIContentClassFieldGroup() 
	{
		this(null);
	}
	
	/**
	 * Constructor
	 * @param path
	 */
	public UIContentClassFieldGroup(String path) 
	{
		super(path);
		fields = new ArrayList<UIContentClassField>();
	}

	public List<UIContentClassField> getFields() 
	{
		return fields;
	}

	public boolean isEmpty()
	{
		if(fields == null) return true;
		return fields.isEmpty();
	}

	@Override
	public boolean hasNonDefaultValues() 
	{
		// Min / Max
		if(getMin() != null || getMax() != null) return true;
		
		return false;
	}
}
