package com.tandbergtv.cms.portal.content.client.contentclass.service;

import java.util.Collection;
import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.contentclass.model.CCPValidationError;
import com.tandbergtv.cms.portal.content.client.contentclass.model.SaveStatus;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Defines methods used by Content Class views
 * @author eyevkar
 */
@RemoteServiceRelativePath("service/content/contentclass/IContentClassViewService")
public interface IContentClassViewService extends RemoteService 
{
	public String RELATIVE_PATH = "service/content/contentclass/IContentClassViewService";
	
	/**
	 * Gets new UI content class object to be displayed in GUI.
	 * @return new UI content class
	 */
	public UIContentClass getNewContentClass() throws NeptuneException;
	
	/**
	 * Gets existing content class
	 * @param contentClassId
	 * @return
	 * @throws NeptuneException
	 */
	public UIContentClass getContentClassById(long contentClassId) throws NeptuneException;

	/**
	 * Saves content class in a database
	 * @param contentClass
	 * @return id of saved content class
	 */
	public long saveContentClass(UIContentClass contentClass) throws NeptuneException;

	/**
	 * Saves content class in a database and validates metadata against all partner overrides.
	 * @param uiContentClass
	 * @param errors
	 * @return
	 * @throws NeptuneException
	 */
	public SaveStatus saveAndValidateContentClass(UIContentClass uiContentClass) throws NeptuneException;
	
	/**
	 * Gets a list of content classes without metadata.
	 * @return
	 */
	public List<UIContentClass> getContentClassListWithoutMetadata() throws NeptuneException;

	/**
	 * Deletes content class by ID
	 * @param ids
	 * @return
	 */
	public List<UIContentClass> deleteContentClassesById(Collection<Long> ids) throws NeptuneException;
	
	/**
	 * Gets content class partner
	 * @param contentClassId
	 * @param partnerId
	 * @return
	 * @throws NeptuneException
	 */
	public UIContentClassPartner getContentClassPartner(long contentClassId, long partnerId) throws NeptuneException;
	
	/**
	 * Saves content class partner 
	 * @param ccp
	 * @throws NeptuneException
	 */
	public void saveContentClassPartner(UIContentClassPartner ccp) throws NeptuneException;
	
	/**
	 * Deletes content class partner 
	 * @param ccp
	 * @throws NeptuneException
	 */
	public void deleteContentClassPartner(UIContentClassPartner ccp) throws NeptuneException;

	/**
	 * Gets UI spec for a content class
	 * @param contentClassId
	 * @return
	 * @throws NeptuneException
	 */
	public UIAssetSpecification getContentClassSpec(long contentClassId, long partnerId) throws NeptuneException;	
	
	/**
	 * Gets UI spec for a content class
	 * @param contentClassId
	 * @return
	 * @throws NeptuneException
	 */
	public UIAssetSpecification getContentClassSpec(long contentClassId) throws NeptuneException;
}
