package com.tandbergtv.cms.portal.content.client.contentclass.service;

import java.util.Collection;
import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.contentclass.model.SaveStatus;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;

/**
 * Async version of IContentClassViewService
 * @author eyevkar
 */
public interface IContentClassViewServiceAsync 
{
	public void getNewContentClass(AsyncCallback<UIContentClass> callback);
	public void getContentClassById(long contentClassId, AsyncCallback<UIContentClass> callback);
	
	public void saveContentClass(UIContentClass contentClass, AsyncCallback<Long> callback);
	public void saveAndValidateContentClass(UIContentClass contentClass, AsyncCallback<SaveStatus> callback);
	
	public void getContentClassListWithoutMetadata(AsyncCallback<List<UIContentClass>> callback);
	public void deleteContentClassesById(Collection<Long> ids, AsyncCallback<List<UIContentClass>> callback);
	
	public void getContentClassPartner(long contentClassId, long partnerId, AsyncCallback<UIContentClassPartner> callback);
	public void saveContentClassPartner(UIContentClassPartner ccp, AsyncCallback<Void> callback);
	public void deleteContentClassPartner(UIContentClassPartner ccp, AsyncCallback<Void> callback);
	
	public void getContentClassSpec(long contentClassId, long partnerId, AsyncCallback<UIAssetSpecification> callback);
	public void getContentClassSpec(long contentClassId, AsyncCallback<UIAssetSpecification> callback);
}
