package com.tandbergtv.cms.portal.content.client.contentclass.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.cms.portal.content.client.bundle.IContentClassResourceBundle;

/**
 * Represents tree item widget displayed by an asset tree.
 * It has an image and a text;
 *   
 * @author eyevkar
 */
public class AssetTreeItemWidget extends HorizontalPanel {
	private static final IContentClassResourceBundle bundle = GWT.create(IContentClassResourceBundle.class);
	
	private Image imgDisabled;
	private boolean disabled;

	/**
	 * Constructor
	 * @param text
	 * @param disabled
	 */
	public AssetTreeItemWidget(String text, boolean disabled) {
		this.disabled = disabled;
		
		// Image
		imgDisabled = new Image(bundle.getDisabledImage());
		imgDisabled.setVisible(disabled);
		
		this.add(imgDisabled);
		this.add(new Label(text));
	}
	
	/**
	 * Constructor
	 * @param text
	 */
	public AssetTreeItemWidget(String text) {
		this(text, true);
	}
	
	/**
	 * Enables an asset tree item
	 */
	public void enable() {
		disabled = false;
		imgDisabled.setVisible(disabled);
	}

	/**
	 * Disables an asset tree item
	 */
	public void disable() {
		disabled = true;
		imgDisabled.setVisible(disabled);
	}
	
}
