package com.tandbergtv.cms.portal.content.client.contentclass.widget;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.bundle.IContentClassResourceBundle;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.ComplexFieldPropertiesDialog;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassFieldWidget.Type;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;

/**
 * Complex field (field group) widget. It is different for 
 * a global content class and for a content class partner.
 * Global content class has the context menu.
 * @author eyevkar
 */
public class ContentClassComplexFieldWidget extends Composite {
	private static final IContentClassResourceBundle bundle = GWT.create(IContentClassResourceBundle.class);
	
	private UIContentClassFieldGroup group;
	private SimplePanel rootPanel;
	
	// Icon indicating that this field is disabled
	private Image disabledImage;

	
	/**
	 * Constructor
	 * @param group
	 */
	public ContentClassComplexFieldWidget(UIContentClassFieldGroup group, boolean isEditable, final UIContentClass cc) {
		this.group = group;

		// Init root panel
		this.rootPanel = new SimplePanel();
		this.initWidget(rootPanel);
		this.addStyleName("ContentClassComplexFieldWidget");
		
		// Validate group
		if(group == null) {
			rootPanel.setWidget(new Label("No Data"));
			return;
		}

		List<UIContentClassField> fields = group.getFields();
		
		// Validate child fields
		if(fields == null || fields.isEmpty()) {
			rootPanel.setWidget(new Label("No Data"));
			return;
		}

		
		// Main panel
		VerticalPanel vp = new VerticalPanel();
		
		// Simple fields
		
		// Create a table
		FlexTable table = new FlexTable();
		table.addStyleName("FormFieldTable");
		
		// Add all simple fields to the table
		int row = 0;
		for(UIContentClassField field: fields) {
			if(!(field instanceof UIContentClassFieldGroup)) {
				// Filter provider id and provider name. They could not be changed and should not be displayed in GUI.
				// if(UIContentClassMetadata.PATH_PROVIDER_ID.equals(field.getPath())) continue;
				// if(UIContentClassMetadata.PATH_PROVIDER_NAME.equals(field.getPath())) continue;
				
				HTML label = new HTML();
				table.setWidget(row, 0, label);
				table.getCellFormatter().setAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT, HasVerticalAlignment.ALIGN_MIDDLE);
				
				ContentClassFieldWidget widget = new ContentClassFieldWidget(Type.ContentClass, field, isEditable, cc, label);
				table.setWidget(row, 1, widget);
				
				if(field.isRequired()) {
					widget.setRequired(true);
				}
				else {
					widget.setRequired(false);
				}

				
				// Increment row
				row++;
			}
		}
		vp.add(table);

		// Complex fields
		for(UIContentClassField field: fields) {
			if(field instanceof UIContentClassFieldGroup) {
				UIContentClassFieldGroup childGroup = (UIContentClassFieldGroup)field;
				Widget groupWidget = new ContentClassComplexFieldWidget(childGroup, isEditable, cc);
				vp.add(groupWidget);
			}
		}

		// Main widget
		RoundedDisclosureContainer rdc = new RoundedDisclosureContainer(group.getDisplayName());
		rdc.setContent(vp);

		// Non-root
		if(group.getPath() != null) {
			// Has widget and icons: context menu icon, disabled icon, etc.
			HorizontalPanel hp = new HorizontalPanel();
			hp.addStyleName("Content");
			hp.add(rdc);
			
			// Context menu
			Anchor contextMenuAnchor = new ImageAnchor(createContextMenuImage());
			ContextMenuClickHandler contextMenuHandler = new ContextMenuClickHandler(this);
			contextMenuAnchor.addClickHandler(contextMenuHandler);
			hp.add(contextMenuAnchor);
			
			// Disabled image
			disabledImage = new Image(bundle.getDisabledImage());
			hp.add(disabledImage);
			if(group.isDisabled()) {
				this.disable();
			}
			else {
				this.enable();
			}
			
			rootPanel.setWidget(hp);
		}
		// Root group
		else {
			rootPanel.setWidget(vp);
		}
		
	}

	public void disable() {
		group.setDisabled(true);
		disabledImage.setVisible(true);
	}
	
	public void enable() {
		group.setDisabled(false);
		disabledImage.setVisible(false);
	}		
		
	public UIContentClassFieldGroup getGroup() {
		return group;
	}
	
	private Image createContextMenuImage() {
		Image img = new Image(bundle.contextMenuImage());
		img.addStyleName("ContextMenuImage");
		return img;
	}

	/**
	 * Click handler for field context menu 
	 * @author eyevkar
	 */
	private static class ContextMenuClickHandler implements ClickHandler {
		private ContentClassComplexFieldWidget widget;
		
		/**
		 * Constructor
		 * @param field
		 */
		public ContextMenuClickHandler(ContentClassComplexFieldWidget widget) {
			this.widget = widget;
		}
		
		@Override
		public void onClick(ClickEvent event) {
			final PopupPanel menuPanel = new PopupPanel(true);
			menuPanel.addStyleName("ContentClassPopupPanel");

			int x = event.getNativeEvent().getClientX() + Window.getScrollLeft();
			int y = event.getNativeEvent().getClientY() + Window.getScrollTop();

			menuPanel.setPopupPosition(x, y);
			
			MenuBar menu = new MenuBar(true);
			
			// Disable/Enable command (only available in gloabal content class)
			if(widget.getGroup().isDisabled()) {
				menu.addItem("Enable", new Command() {
					@Override
					public void execute() {
						widget.enable();
						menuPanel.hide();
					}
				});
			}
			else {
				menu.addItem("Disable", new Command() {
					@Override
					public void execute() {
						widget.disable();
						menuPanel.hide();
					}
				});
			}			

			// Properties
			// NOTE: Right now we only can edit cardinality in properties dialog, so that's why this
			// menu item is only shown for fields that support multiple values.
			if(widget.getGroup().isMultiValue()) {
				menu.addItem("Properties...", new Command() {
					@Override
					public void execute() {
						menuPanel.hide();
						ComplexFieldPropertiesDialog dialog = new ComplexFieldPropertiesDialog(widget);
						dialog.center();
					}
				});
			}
			
			menuPanel.add(menu);
			menuPanel.show();
		}
	}
	
}
