package com.tandbergtv.cms.portal.content.client.contentclass.widget;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.CCDateWidget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;


/**
 * Handles changes to values of date box. It is only used for field type of DATE.
 * For other data type handlers see {@link ContentClassValueChangeHandler}
 * @author eyevkar
 */
public class ContentClassDateValueChangeHandler implements ValueChangeHandler<String> {
	private UIContentClassField field;
	
	/**
	 * Constructor
	 * @param field
	 */
	public ContentClassDateValueChangeHandler(UIContentClassField field) {
		this.field = field;
	}
	
	@Override
	public void onValueChange(ValueChangeEvent<String> event) 
	{
		String eventValue = event.getValue();
		CCDateWidget widget = (CCDateWidget)event.getSource();
		if(widget.isValidValue())
		{
			field.setValue(event.getValue());
		}
		else 
		{
			field.setValue(widget.getTextValue());
		}
	}
}
