package com.tandbergtv.cms.portal.content.client.contentclass.widget;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.FieldPropertiesDialog;

/**
 * An image wrapped by an anchor
 * @author eyevkar
 */
public class ImageAnchor extends Anchor 
{
	private FieldPropertiesDialog.ContextMenuClickHandler contextMenuClickHandler;
	
	/**
	 * Constructor
	 * @param img
	 */
	public ImageAnchor(Image img) 
	{
		super();
		getElement().appendChild(img.getElement());
	    img.unsinkEvents(Event.ONCLICK | Event.MOUSEEVENTS);
	    sinkEvents(Event.ONCLICK | Event.MOUSEEVENTS);
	}
	
	public void setContextMenuClickHandler(FieldPropertiesDialog.ContextMenuClickHandler handler)
	{
		this.contextMenuClickHandler = handler;
		addClickHandler(handler);
	}
	
	public FieldPropertiesDialog.ContextMenuClickHandler getContextMenuClickHandler()
	{
		return contextMenuClickHandler;
	}
}
