package com.tandbergtv.cms.portal.content.client.create.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Data for content create screen 
 * @author eyevkar
 */
public class ContentCreateData implements IsSerializable 
{
	private List<UISourcePartner> sourcePartnerList = new ArrayList<UISourcePartner>();
	
	/**
	 * Public constructor
	 */
	public ContentCreateData() {
	}

	public List<UISourcePartner> getSourcePartnerList() {
		return sourcePartnerList;
	}

	public void addSourcePartner(UISourcePartner sourcePartner) {
		this.sourcePartnerList.add(sourcePartner);
	}
	
	public UISourcePartner getSourcePartnerById(String sid) {
		try {
			long id = Long.parseLong(sid);
			// Iterate over the list. Probably a map can be used instead, but 
			// number of record is small anyway, so a list is simpler and needs less memory.
			for(UISourcePartner partner: sourcePartnerList) {
				if(partner.getId() == id) {
					return partner;
				}
			}
			return null;
		}
		catch(Exception ex) {
			return null;
		}
	}
	
	public void sort() {
		// Sort partners by name
		Collections.sort(sourcePartnerList);
		// For each partner sort content classes by name 
		for(UISourcePartner partner: sourcePartnerList) {
			partner.sortContentClasses();
		}
	}
	
	public UIContentClass findContentClass(long partnerId, long contentClassId)
	{
		UISourcePartner partner = findPartner(partnerId);
		if(partner != null)
		{
			return partner.findContentClass(contentClassId);
		}
		
		return null;
	}
	
	private UISourcePartner findPartner(long partnerId)
	{
		for(UISourcePartner partner: sourcePartnerList) 
		{
			if(partner.getId() == partnerId) return partner;
		}
		
		return null;
	}
}
