package com.tandbergtv.cms.portal.content.client.create.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Used by content create step 1 screen to display two dropdowns with 
 * source partners and content classes  
 * @author eyevkar
 */
public class UISourcePartner implements IsSerializable, Comparable<UISourcePartner> 
{
	private long id;
    private String displayName;
    private List<UIContentClass> contentClassList = new ArrayList<UIContentClass>();

    /**
     * Default constructor required by GWT for serialization.
     */
    public UISourcePartner() {
    }

    public UISourcePartner(long id, String displayName) {
    	this.id = id;
    	this.displayName = displayName;
    }

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public List<UIContentClass> getContentClassList() {
		return contentClassList;
	}

	public void addContentClass(UIContentClass contentClass) {
		this.contentClassList.add(contentClass);
	}
    
	public void sortContentClasses() {
		Collections.sort(this.contentClassList);
	}

	public UIContentClass findContentClass(long contentClassId)
	{
		for(UIContentClass cc: contentClassList)
		{
			if(cc.id == contentClassId) return cc;
		}
		
		return null;
	}
	
	@Override
	public int compareTo(UISourcePartner o) {
		return this.getDisplayName().compareTo(o.getDisplayName());
	}
}
