package com.tandbergtv.cms.portal.content.client.customfield.enums;

public enum FieldTypeOptionsEnum {
	TEXT_BOX(1, "Text Box"), DROP_DOWN(2, "Drop Down"), COMBO_BOX(3, "Combo Box"), TEXT_AREA(4, "Text Area");
	int id;
	String name;
	private FieldTypeOptionsEnum(int id, String name) {
		this.id = id;
		this.name = name;
	}
	public int getId() {
		return id;
	}
	public String getName() {
		return name;
	}
	public static FieldTypeOptionsEnum fromName(String name) {
		if(name != null) {
			for (FieldTypeOptionsEnum option: FieldTypeOptionsEnum.values()) {
			if(name.equalsIgnoreCase(option.getName())) {
				return option;
			}
		}
		}
		return null;
	}
	public static FieldTypeOptionsEnum fromId(int id) {
		if(id != 0) {
			for (FieldTypeOptionsEnum option: FieldTypeOptionsEnum.values()) {
			if(id == option.getId()) {
				return option;
			}
		}
		}
		return null;
	}
}
