package com.tandbergtv.cms.portal.content.client.customfield.model;

import com.google.gwt.user.client.rpc.IsSerializable;


public class UICustomField implements IsSerializable {

	private long id = 0;
	private String assetPath;
	private String name;
	private String displayName;
	private String dataType;
	private int fieldType = 0;
	private boolean multiValue;
	private boolean jobParameter;
	private boolean jobScheduleParameter;
	private UICustomFieldGroup group;
	private boolean duplFlag = false;
	private boolean compareById = false;
	

	public UICustomField() {}
	
	
	public boolean isMultiValue() {
		return multiValue;
	}


	public void setMultiValue(boolean multiValue) {
		this.multiValue = multiValue;
	}


	public long getId() {
		return id;
	}



	public void setId(long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getDisplayName() {
		return displayName;
	}
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	public String getDataType() {
		return dataType;
	}
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}
	
	public int getFieldType() {
		return fieldType;
	}

	public boolean isDuplFlag() {
		return duplFlag;
	}


	public void setDuplFlag(boolean duplFlag) {
		this.duplFlag = duplFlag;
	}
	public void setFieldType(int fieldType) {
		this.fieldType = fieldType;
	}


	public boolean isJobParameter() {
		return jobParameter;
	}
	public void setJobParameter(boolean jobParameter) {
		this.jobParameter = jobParameter;
	}
	public boolean isJobScheduleParameter() {
		return jobScheduleParameter;
	}
	public void setJobScheduleParameter(boolean jobScheduleParameter) {
		this.jobScheduleParameter = jobScheduleParameter;
	}
	public UICustomFieldGroup getGroup() {
		return group;
	}
	public void setGroup(UICustomFieldGroup group) {
		this.group = group;
	}
	public String getAssetPath() {
		return group.getAssetPath();
		
	}


	public void setAssetPath(String assetPath) {
		if(this.group != null) {
			this.assetPath = group.getAssetPath();
		}
	}


	@Override
	public int hashCode() {
		
		if(this.name != null && this.assetPath != null) {
			return (int)this.name.hashCode() * this.assetPath.hashCode();
		}
		else {
			return 0;
		}
	}
	@Override
	public boolean equals(Object obj) {
		
		
//		 if (this == obj) {
//		        return true;
//		 }
		    if (obj == null) {
		        return false;
		    }
		    if (!(obj instanceof UICustomField)) {
		        return false;
		    }
		    final UICustomField other = (UICustomField)obj;
		    this.duplFlag = false;
		    //other.setDuplFlag(false);
		    if(compareById) {
		    	
	    		 if(this.name != null && other.name != null && this.group.getAssetPath() != null && other.group.getAssetPath() != null) {
	 		    	if(this.name.equals(other.name) &&
	 		    			this.group.getAssetPath().equalsIgnoreCase(other.group.getAssetPath())) {
	 		    		if(this.id == other.id) {
	 		    			return true;
	 		    		}
	 		    	}
	    		 }
		    	
		    }
		    else if(this.name != null && other.name != null && this.group.getAssetPath() != null && other.group.getAssetPath() != null) {
		    	if(this.name.equals(other.name) &&
		    			this.group.getAssetPath().equalsIgnoreCase(other.group.getAssetPath())) {
		    		return true;
		    	}
		    	//different assets, if datatype not
		    	if(this.name.equals(other.name) && !this.group.getAssetPath().equalsIgnoreCase(other.group.getAssetPath())) {
		    		if(!this.dataType.equalsIgnoreCase(other.dataType)) {
		    			this.duplFlag = true;
		    			other.setDuplFlag(true);
		    			
		    		}
		    	}
		    		
		    }
		    return false;
	}
	
	public boolean isCompareById() {
		return compareById;
	}


	public void setCompareById(boolean compareById) {
		this.compareById = compareById;
	}


}
