package com.tandbergtv.cms.portal.content.client.customfield.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomField;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldGroup;

public class CustomFieldUtil {

	public static <T> List getDuplicate(Collection<T> list) {

	    final List<T> duplicatedObjects = new ArrayList<T>();
	    Set<T> set = new HashSet<T>() {
	    @Override
	    public boolean add(T e) {
	        if (contains(e)) {
	            duplicatedObjects.add(e);
	        }
	        return super.add(e);
	    }
	    };
	   for (T t : list) {
	        set.add(t);
	    }
	    return duplicatedObjects;
	}


	public static <T> boolean hasDuplicate(Collection<T> list) {
	    if (getDuplicate(list).isEmpty())
	        return false;
	    return true;
	}
	public static boolean hasDuplicatesManyAssets(List<UICustomField> fieldList) {
		final List<UICustomField> duplList = new ArrayList<UICustomField>();
		 Set<UICustomField> set = new HashSet<UICustomField>() {
			    @Override
			    public boolean add(UICustomField e) {
			        if (contains(e)) {
			        	duplList.add(e);
			        }
			        return super.add(e);
			    }
			    };
			   for (UICustomField field : fieldList) {
			        set.add(field);
			    }
		
		return false;
	}

	public static String getDuplicatesMessage(List<UICustomField> duplicates) {
		String duplString = "";
		for(UICustomField field: duplicates) {
			duplString += field.getAssetPath() + " : " + field.getName() + "\n";
		}
		return duplString;
	}


	public static String getDuplicateMessage(
			List<UICustomFieldGroup> duplicates) {
		String duplString = "";
		for(UICustomFieldGroup group: duplicates) {
			duplString += group.getAssetPath() + " : " + group.getDisplayName()+ "\n";
		}
		return duplString;
		
	}
	public static String convert(boolean value) {
		String token;
		if(value) {
			token = "Y";
		}
		else {
			token = "N";
		}
		return token;
	}

	public static boolean convertToBoolean(String field) {
		if(field != null ) {
			if(field.equalsIgnoreCase("Y")) {
				return true;
			}
		}
		return false;
	}

}
