package com.tandbergtv.cms.portal.content.client.customfield.view;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldGroup;
import com.tandbergtv.cms.portal.ui.title.client.model.search.MessageContainer;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class CustomFieldAdministrationView extends Composite {

	private SimpleContainer rootContainer;
	private LabelWidget lblTitle;
	private Button btnSave;
	private HeaderPanel headerPanel;
	private TabContainer tabContainer;
	private CustomFieldTabView tabView;
	private MessageArea messageArea = new MessageArea();
	private BusyIndicator busyIndicator;

	public CustomFieldAdministrationView() {

		rootContainer = new SimpleContainer();
		headerPanel = new HeaderPanel("Custom Field Administration");
		headerPanel.addStyleName("nwt-Header-Panel");
		rootContainer.setWidget(null);
		tabView = new CustomFieldTabView(messageArea);
		this.busyIndicator = new BusyIndicator();
		this.initWidget(rootContainer);
		this.addStyleName("ContentClassEditView");
		btnSave = new Button("Save");
		btnSave.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		if (!ClientAuthorizationManager.isAuthorized(Permissions.CUSTOMFIELDS_ADMINISTER) ) {
			btnSave.setVisible(false);
		}
		btnSave.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
		
				if (!tabView.saveAll()) {
					setDataScrollSize();
					
					return;
				}
		
			}
			
		});
		HorizontalPanel buttonPanel = new HorizontalPanel();
		buttonPanel.add(btnSave);
		
		buttonPanel.addStyleName("ButtonPanel");
		
		tabContainer = new TabContainer();
		VerticalPanel vpTab = new VerticalPanel();
		vpTab.add(tabView);
		vpTab.add(buttonPanel);
		tabContainer.add(vpTab, "Custom Fields");
		
		tabContainer.addStyleDependentName("metadata");
		tabContainer.selectTab(0);
		VerticalPanel vp = new VerticalPanel();
		vp.setWidth("100%");
		vp.add(headerPanel);
		vp.add(messageArea);
		
		vp.add(tabContainer);
		
		//vp.add(buttonPanel);
		vp.setSpacing(3);

		rootContainer.setWidget(vp);

	}
	private void setDataScrollSize() {
		CustomFieldGroupsView groupsView = this.tabView.getGroupsView();
		groupsView.setDataScrollSize();
		groupsView.setAssetScrollSize();
		
		//hideBusyIndicator();
	}
	/**
	 * @return the busy indicator
	 */
	BusyIndicator getBusyIndicator() {
		return this.busyIndicator;
	}

	/**
	 * Show the busy indicator in the center of the browser
	 */
	void showBusyIndicator() {
		this.busyIndicator.center();
	}

	/**
	 * Hide the busy indicator, if showing
	 */
	void hideBusyIndicator() {
		this.busyIndicator.hide();
	}
	

}
