package com.tandbergtv.cms.portal.content.client.customfield.view;

import java.util.ArrayList;
import java.util.List;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable.Cell;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.customfield.enums.CustomFieldDataType;
import com.tandbergtv.cms.portal.content.client.customfield.enums.FieldTypeOptionsEnum;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomField;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldAsset;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldGroup;
import com.tandbergtv.cms.portal.content.client.customfield.rpc.ICustomFieldViewService;
import com.tandbergtv.cms.portal.content.client.customfield.rpc.ICustomFieldViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewResources;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class CustomFieldGroupsView extends Composite {
	private UICustomFieldAsset assetDisplayed;
	private TreeItem itemDisplayed;
	private VerticalPanel multiGroupsPanel;
	private HorizontalPanel groupButtonPanel;
	private Button btnAddGroup;
	private static final int SCROLL_CUT = 240;
	private static final int SCROLL_CUT_BOTTOM = 40;
	private static final int SCROLL_WIDTH_CUT = 300;
	public static final String STYLE_CATEGORY_METADATA_AREA = "customField-area";
	private static final String ERROR_STYLE = "WidgetValidationError";
	private ICustomFieldViewServiceAsync viewService;
	private MessageArea messageContainer;
	final ScrollContainer dataScroll = new ScrollContainer();
	ScrollPanel assetScroll;
	private ContentConstants myConstants = (ContentConstants) GWT.create(ContentConstants.class);

	boolean refresh = false;

	public CustomFieldGroupsView(final UICustomFieldAsset assetDisplayed, boolean refresh, final ScrollPanel assetScroll, MessageArea messageContainer) {

		this.messageContainer = messageContainer;
		this.refresh = refresh;
		this.viewService = GWT.create(ICustomFieldViewService.class);
		this.assetScroll = assetScroll;
		this.assetDisplayed = assetDisplayed;
		multiGroupsPanel = new VerticalPanel();
		groupButtonPanel = new HorizontalPanel();
		btnAddGroup = new Button("Add Group");
		btnAddGroup.addStyleDependentName("act-towards-save-button");
		dataScroll.addStyleName(STYLE_CATEGORY_METADATA_AREA);
		if (!ClientAuthorizationManager.isAuthorized(Permissions.CUSTOMFIELDS_ADMINISTER)) {
			btnAddGroup.setVisible(false);
		}
		setDataScrollSize();
		setAssetScrollSize();

		Window.addResizeHandler(new ResizeHandler() {

			@Override
			public void onResize(ResizeEvent event) {
				int height = event.getHeight();
				int width = event.getWidth();
				setResizeSize(height, width, assetScroll);

			}

		});
		btnAddGroup.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				showGroupBox();
			}

		});

		final List<UICustomFieldGroup> groupList = assetDisplayed.getGroupList();
		if (groupList != null && !groupList.isEmpty()) {
			// display existing list
			for (final UICustomFieldGroup group : groupList) {
				Label groupDisplayNameLbl = new Label("Display Name");
				Label fieldsLbl = new Label("Fields");
				HorizontalContainer headingPanel = new HorizontalContainer();
				headingPanel.addStyleName("content-ComplexFieldWidget-disclosureHeader");

				/* Heading label */
				LabelWidget headingLabel = new LabelWidget(group.getDisplayName());
				headingLabel.addStyleName("content-ComplexFieldWidget-disclosureHeader-label");
				headingPanel.add(headingLabel);

				headingPanel.setWidth("100%");
				/* The remove button */
				Button btnDeleteGroup = new Button("Delete");
				btnDeleteGroup.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
				headingPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
				headingPanel.add(btnDeleteGroup);
				if (!ClientAuthorizationManager.isAuthorized(Permissions.CUSTOMFIELDS_ADMINISTER)) {
					btnDeleteGroup.setVisible(false);
				}
				final RoundedDisclosureContainer groupContainer = new RoundedDisclosureContainer(headingPanel, true);
				groupContainer.setAnimationEnabled(true);
				groupContainer.setOpen(true);
				// groupContainer.setWidth("100%");
				VerticalPanel groupV = new VerticalPanel();
				final TextBox groupDisplayNameTxt = new TextBox();
				groupDisplayNameTxt.setText(group.getDisplayName());
				groupDisplayNameTxt.setWidth("250px");
				groupDisplayNameTxt.setMaxLength(255);
				groupDisplayNameTxt.addKeyUpHandler(new KeyUpHandler() {
					@Override
					public void onKeyUp(KeyUpEvent event) {
						group.setDisplayName(groupDisplayNameTxt.getText());
						group.setAssetPath(assetDisplayed.getAssetPath());

					}
				});
				FlexTable groupTable = new FlexTable();

				groupTable.setWidget(0, 0, groupDisplayNameLbl);
				groupTable.setWidget(0, 1, groupDisplayNameTxt);
				groupTable.setWidget(1, 0, fieldsLbl);

				groupV.add(groupTable);
				FlexTableContainer fieldsTable = new FlexTableContainer();
				fieldsTable.addStyleName("content-AssetContentTable");

				// fieldsTable.setWidth("100%");
				// header
				buildTableHeader(fieldsTable);

				List<UICustomField> fieldList = group.getFieldList();
				if (fieldList != null && !fieldList.isEmpty()) {
					// build fields table

					int rowCounter = 1; // start with 1
					for (UICustomField field : fieldList) {

						setFieldTableRow(field, rowCounter, fieldsTable);
						rowCounter++;
					}
					// add always default empty row, but not always. check first
					// if one exists
					UICustomField lastField = fieldList.get(fieldList.size() - 1);
					if (lastField.getName() != null && !lastField.getName().isEmpty()) {
						UICustomField defaultField = new UICustomField();
						defaultField.setGroup(group);
						group.addFieldList(defaultField);
						setFieldTableRow(defaultField, rowCounter, fieldsTable);
					}
					groupV.add(fieldsTable);
				} else {
					// add empty row,
					UICustomField emptyField = new UICustomField();
					emptyField.setGroup(group);
					group.addFieldList(emptyField);
					setFieldTableRow(emptyField, 1, fieldsTable);
					groupV.add(fieldsTable);
				}

				groupContainer.add(groupV);

				multiGroupsPanel.add(groupContainer);
				groupButtonPanel.add(btnAddGroup);
				// groupButtonPanel.add(btnDeleteGroup);
				multiGroupsPanel.add(groupButtonPanel);
				multiGroupsPanel.setSpacing(8);
				btnDeleteGroup.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						groupList.remove(group);
						groupContainer.setVisible(false);
					}

				});

			}
		} else {
			multiGroupsPanel.add(btnAddGroup);
			multiGroupsPanel.setSpacing(8);

			// just add button showGroupBox();
		}
		dataScroll.clear();
		dataScroll.add(multiGroupsPanel);
		this.initWidget(dataScroll);

	}

	public ScrollPanel getAssetScroll() {
		return assetScroll;
	}

	public void setAssetScrollSize() {
		assetScroll.setWidth("225");
		SimplePanel assetPanel = (SimplePanel) assetScroll.getWidget();
		int assetPanelHeight = Window.getClientHeight() - SCROLL_CUT - messageContainer.getOffsetHeight() - SCROLL_CUT_BOTTOM;
		assetPanel.setHeight(String.valueOf(assetPanelHeight) + "px");
		// assetScroll.setHeight(String.valueOf(assetPanelHeight) + "px");

	}

	public void setDataScrollSize() {
		int width = Window.getClientWidth() < 900 ? 900 : Window.getClientWidth() - SCROLL_WIDTH_CUT;
		dataScroll.setHeight(String.valueOf(Window.getClientHeight() - SCROLL_CUT - messageContainer.getOffsetHeight() - SCROLL_CUT_BOTTOM) + "px"); // 115
		dataScroll.setWidth(String.valueOf(Window.getClientWidth() < 900 ? 900 : Window.getClientWidth() - SCROLL_WIDTH_CUT) + "px");
	}

	public UICustomFieldAsset getAssetDisplayed() {
		return assetDisplayed;
	}

	private void buildTableHeader(FlexTable fieldsTable) {

		fieldsTable.setWidget(0, 0, new LabelWidget("Name"));
		fieldsTable.setWidget(0, 1, new LabelWidget("Display Name"));
		fieldsTable.setWidget(0, 2, new LabelWidget("Datatype"));
		fieldsTable.setWidget(0, 3, new LabelWidget("Field Type"));
		fieldsTable.setWidget(0, 4, new LabelWidget("Multivalue"));
		fieldsTable.setWidget(0, 5, new LabelWidget("Job Parameter"));
		fieldsTable.setWidget(0, 6, new LabelWidget("Schedule Parameter"));

		for (int i = 0; i <= 6; i++) {

			fieldsTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell");
			fieldsTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell-header");
			Widget widget = fieldsTable.getWidget(0, i);
			if (widget instanceof LabelWidget) {
				widget.addStyleName("content-AssetContentTable-header-text");
			}
		}
		fieldsTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row");
		fieldsTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row-header");
	}

	// new group box
	private void showGroupBox() {
		final UICustomFieldGroup group = new UICustomFieldGroup();
		assetDisplayed.addGroup(group);
		group.setAssetPath(assetDisplayed.getAssetPath());
		HorizontalContainer headingPanel = new HorizontalContainer();
		headingPanel.addStyleName("content-ComplexFieldWidget-disclosureHeader");
		/* Heading label */
		LabelWidget headingLabel = new LabelWidget(group.getDisplayName());
		headingLabel.addStyleName("content-ComplexFieldWidget-disclosureHeader-label");
		headingPanel.add(headingLabel);
		headingPanel.setWidth("100%");
		/* The remove button */
		Button btnDeleteGroup = new Button("Delete");
		btnDeleteGroup.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		headingPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		headingPanel.add(btnDeleteGroup);
		if (!ClientAuthorizationManager.isAuthorized(Permissions.CUSTOMFIELDS_ADMINISTER)) {
			btnDeleteGroup.setVisible(false);
		}

		final RoundedDisclosureContainer groupContainer = new RoundedDisclosureContainer(headingPanel);
		groupContainer.setAnimationEnabled(true);
		groupContainer.setOpen(true);
		groupContainer.setWidth("100%");
		VerticalPanel groupV = new VerticalPanel();
		Label groupDisplayNameLbl = new Label("Display Name");
		Label fieldsLbl = new Label("Fields");

		final TextBox groupDisplayNameTxt = new TextBox();
		groupDisplayNameTxt.setText(group.getDisplayName());
		groupDisplayNameTxt.addKeyUpHandler(new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
				group.setDisplayName(groupDisplayNameTxt.getText());
				group.setAssetPath(assetDisplayed.getAssetPath());

			}
		});

		groupDisplayNameTxt.setWidth("250px");
		groupDisplayNameTxt.setMaxLength(255);
		FlexTable groupTable = new FlexTable();

		groupTable.removeAllRows();
		groupTable.setWidget(0, 0, groupDisplayNameLbl);

		groupTable.setWidget(0, 1, groupDisplayNameTxt);
		groupTable.setWidget(1, 0, fieldsLbl);
		groupV.remove(groupTable);
		groupV.add(groupTable);

		UICustomField field = new UICustomField();
		FlexTableContainer fieldsTable = new FlexTableContainer();
		fieldsTable.addStyleName("content-AssetContentTable");

		// fieldsTable.setWidth("100%");
		// header
		buildTableHeader(fieldsTable);
		group.addFieldList(field);
		field.setGroup(group);
		setFieldTableRow(field, 1, fieldsTable);

		groupV.add(fieldsTable);
		groupContainer.add(groupV);
		multiGroupsPanel.add(groupContainer);
		groupButtonPanel.add(btnAddGroup);
		// groupButtonPanel.add(btnDeleteGroup);
		multiGroupsPanel.add(groupButtonPanel);

		multiGroupsPanel.setSpacing(8);
		btnDeleteGroup.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				assetDisplayed.getGroupList().remove(group);
				groupContainer.setVisible(false);
			}

		});
	}

	private void setFieldTableRow(final UICustomField field, final int row, final FlexTable fieldsTable) {
		fieldsTable.getRowFormatter().addStyleName(row, "content-AssetContentTable-row");
		fieldsTable.getRowFormatter().addStyleName(row, "content-AssetContentTable-row-body");

		ImageWidget image = new ImageWidget(TitleViewResources.DELETE_IMAGE_URL);
		final PushButtonWidget deleteButton = new PushButtonWidget(image);
		deleteButton.addStyleName(TitleViewResources.STYLE_FIELD_DELETE_BUTTON);
		deleteButton.setEnabled(true);

		deleteButton.setVisible(true);

		final CheckBox scheduleParameter = new CheckBox();
		final TextBox name = new TextBox();
		name.setText(field.getName());
		name.setWidth("180px");
		name.setMaxLength(255);
		if (!ClientAuthorizationManager.isAuthorized(Permissions.CUSTOMFIELDS_ADMINISTER) && name.isReadOnly()) {
			deleteButton.setVisible(false);

		}
		if (ClientAuthorizationManager.isAuthorized(Permissions.CUSTOMFIELDS_ADMINISTER)) {

			name.addKeyUpHandler(new KeyUpHandler() {
				@Override
				public void onKeyUp(KeyUpEvent event) {
					field.setName(name.getText());

				}
			});

			final NameHandler nameHandler = new NameHandler();
			nameHandler.setRegistration(name.addKeyUpHandler(new KeyUpHandler() {
				@Override
				public void onKeyUp(KeyUpEvent event) {
					field.setName(name.getText());
					if (field.getName() != null && field.getName().length() >= 1) {
						UICustomField uiField = new UICustomField();
						uiField.setGroup(field.getGroup());
						field.getGroup().addFieldList(uiField);
						fieldsTable.setWidget(fieldsTable.getRowCount() - 1, 7, deleteButton);
						addFieldTableRow(fieldsTable, uiField);
						nameHandler.getRegistration().removeHandler();
					}
				}
			}));
		}
		// field type list
		final List<String> fieldTypeList = new ArrayList<String>();
		final ListBox fieldTypeBox = new ListBox();
		setFieldTypeBox(fieldTypeList, fieldTypeBox, field);

		// /list
		final List<String> typeList = new ArrayList<String>();
		final ListBox typeBox = new ListBox();
		setDatatypeBox(typeList, typeBox, field, scheduleParameter, fieldTypeList, fieldTypeBox);

		if (field.getName() != null && !field.getName().isEmpty()) {
			viewService.isValidField(field.getName(), field.getDisplayName(), field.getAssetPath(), field.getGroup().getDisplayName(), new AsyncCallback<java.lang.Boolean>() {

				@Override
				public void onFailure(Throwable caught) {
					// TODO Auto-generated method stub

				}
				@Override
				public void onSuccess(Boolean result) {
					if (result) {
						if( field.getId() >0) {
							name.setReadOnly(true);
							name.setEnabled(false);
						}
							if (!ClientAuthorizationManager.isAuthorized(Permissions.CUSTOMFIELDS_ADMINISTER)) {
							deleteButton.setVisible(false);
						}
						int index = typeList.indexOf(field.getDataType());
						typeBox.setSelectedIndex(index);

						typeBox.setEnabled(false);
					}

				}

			});

		}

		final TextBox displayName = new TextBox();
		displayName.setText(field.getDisplayName());
		displayName.setWidth("180px");
		displayName.setMaxLength(255);
		displayName.addKeyUpHandler(new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
				field.setDisplayName(displayName.getText());

			}
		});

		CheckBox multiValue = new CheckBox();
		multiValue.setValue(field.isMultiValue());
		multiValue.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				boolean checked = ((CheckBox) sender).isChecked();
				field.setMultiValue(checked);
			}
		});

		CheckBox jobParameter = new CheckBox();
		jobParameter.setValue(field.isJobParameter());
		jobParameter.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				boolean checked = ((CheckBox) sender).isChecked();
				field.setJobParameter(checked);
			}
		});

		scheduleParameter.setValue(field.isJobScheduleParameter());
		scheduleParameter.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				boolean checked = ((CheckBox) sender).isChecked();
				field.setJobScheduleParameter(checked);
			}
		});
		if (field.getDataType() != null) {
			if (!field.getDataType().equalsIgnoreCase(CustomFieldDataType.DATE.toString())) {
				scheduleParameter.setEnabled(false);
			}
		}
		fieldsTable.setWidget(row, 0, name);
		fieldsTable.setWidget(row, 1, displayName);
		fieldsTable.setWidget(row, 2, typeBox);
		fieldsTable.setWidget(row, 3, fieldTypeBox);
		fieldsTable.setWidget(row, 4, multiValue);
		fieldsTable.setWidget(row, 5, jobParameter);
		fieldsTable.setWidget(row, 6, scheduleParameter);
		if (field.getName() != null) {
			fieldsTable.setWidget(row, 7, deleteButton);
		}

		for (int i = 3; i <= 7; i++) {
			fieldsTable.getFlexCellFormatter().setHorizontalAlignment(row, i, HasAlignment.ALIGN_CENTER);
			fieldsTable.getCellFormatter().addStyleName(row, i, "content-AssetContentTable-cell");
			fieldsTable.getCellFormatter().addStyleName(row, i, "content-AssetContentTable-cell-body");
		}

		/* Event handler */
		deleteButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
					field.setCompareById(true);
					field.getGroup().getFieldList().remove(field);
				
					field.setCompareById(false);
				Cell cell = fieldsTable.getCellForEvent(event);
				int x = cell.getRowIndex();
				fieldsTable.removeRow(x);
				int count = fieldsTable.getRowCount();
				if (count == 2) {
				//	removeHeaderColumn();
				//	fieldsTable.removeAllRows();
				//	UICustomField uiField = new UICustomField();
				//	uiField.setGroup(field.getGroup());
				//	field.getGroup().addFieldList(uiField);
					// fieldsTable.setWidget(fieldsTable.getRowCount()-1, 7,
					// deleteButton);
					buildTableHeader(fieldsTable);
				//	addFieldTableRow(fieldsTable, uiField);
				}

			}



		});
	}

	private void setDatatypeBox(final List<String> typeList, final ListBox typeBox, final UICustomField field, final CheckBox scheduleParameter, final List<String> fieldTypeList,
			final ListBox fieldTypeBox) {
		for (CustomFieldDataType dataType : CustomFieldDataType.values()) {
			typeBox.addItem(dataType.toString());
			typeList.add(dataType.toString());
		}
		// but make sure it is not been persisted yet
		if (field.getDataType() != null) {
			int index = typeList.indexOf(field.getDataType());
			typeBox.setSelectedIndex(index);

		} else {
			// default
			typeBox.setSelectedIndex(0);
			field.setDataType(CustomFieldDataType.STRING.toString());
		}

		typeBox.addChangeListener(new ChangeListener() {

			@Override
			public void onChange(Widget sender) {
				int index = typeBox.getSelectedIndex();
				String value = typeBox.getValue(index);
				field.setDataType(value);
				if (!value.equalsIgnoreCase(CustomFieldDataType.DATE.toString())) {
					scheduleParameter.setValue(false);
					scheduleParameter.setEnabled(false);
				} else {
					scheduleParameter.setEnabled(true);
				}
				if (value.equalsIgnoreCase(CustomFieldDataType.BOOLEAN.toString())) {
					// fieldTypeList.removeAll(fieldTypeList);
					// fieldTypeList.add(FieldTypeOptionsEnum.DROP_DOWN.getName());
					fieldTypeBox.clear();

					fieldTypeBox.addItem(FieldTypeOptionsEnum.DROP_DOWN.getName());
					fieldTypeBox.setSelectedIndex(0);
					field.setFieldType(FieldTypeOptionsEnum.DROP_DOWN.getId());
				} else if(value.equalsIgnoreCase(CustomFieldDataType.DATE.toString()) || value.equalsIgnoreCase(CustomFieldDataType.TIME.toString()))  {
					fieldTypeBox.clear();
					for (FieldTypeOptionsEnum option : FieldTypeOptionsEnum.values()) {
						if (!option.equals(FieldTypeOptionsEnum.COMBO_BOX)) {
							fieldTypeBox.addItem(option.getName());
							fieldTypeList.add(option.getName());
						}

					}
					fieldTypeBox.setSelectedIndex(0);
					field.setFieldType(FieldTypeOptionsEnum.TEXT_BOX.getId());
				}
				else if (value.equalsIgnoreCase(CustomFieldDataType.STRING.toString())) {
					fieldTypeBox.clear();
					for (FieldTypeOptionsEnum option : FieldTypeOptionsEnum.values()) {
						fieldTypeBox.addItem(option.getName());
						fieldTypeList.add(option.getName());
					}
					fieldTypeBox.setSelectedIndex(0);
					field.setFieldType(FieldTypeOptionsEnum.TEXT_BOX.getId());
				} else {// all other fields do not have text area
					fieldTypeBox.clear();
					for (FieldTypeOptionsEnum option : FieldTypeOptionsEnum.values()) {
						if (!option.equals(FieldTypeOptionsEnum.TEXT_AREA)) {
							fieldTypeBox.addItem(option.getName());
							fieldTypeList.add(option.getName());
						}

					}
					fieldTypeBox.setSelectedIndex(0);
					field.setFieldType(FieldTypeOptionsEnum.TEXT_BOX.getId());
				}
			}
		});

	}

	private void setFieldTypeBox(List<String> fieldTypeList, final ListBox fieldTypeBox, final UICustomField field) {
		if (field.getDataType() != null) {
			if (field.getDataType().equalsIgnoreCase(CustomFieldDataType.BOOLEAN.toString())) {

				fieldTypeBox.clear();
				fieldTypeBox.addItem(FieldTypeOptionsEnum.DROP_DOWN.getName());
				fieldTypeBox.setSelectedIndex(0);
				field.setFieldType(FieldTypeOptionsEnum.DROP_DOWN.getId());
			} else if (field.getDataType().equalsIgnoreCase(CustomFieldDataType.STRING.toString())) {
				for (FieldTypeOptionsEnum option : FieldTypeOptionsEnum.values()) {
					fieldTypeBox.addItem(option.getName());
					fieldTypeList.add(option.getName());
				}
				if (field.getFieldType() != 0) {
					int index = fieldTypeList.indexOf(FieldTypeOptionsEnum.fromId(field.getFieldType()).getName());
					fieldTypeBox.setSelectedIndex(index);
				}

			}
			else if(field.getDataType().equalsIgnoreCase(CustomFieldDataType.DATE.toString()) || field.getDataType().equalsIgnoreCase(CustomFieldDataType.TIME.toString())) {
				for (FieldTypeOptionsEnum option : FieldTypeOptionsEnum.values()) {
					if (!option.equals(FieldTypeOptionsEnum.COMBO_BOX)) {
						fieldTypeBox.addItem(option.getName());
						fieldTypeList.add(option.getName());
					}
				}
				if (field.getFieldType() != 0) {
					int index = fieldTypeList.indexOf(FieldTypeOptionsEnum.fromId(field.getFieldType()).getName());
					fieldTypeBox.setSelectedIndex(index);
				}
				
			}
			
			else {
				// not new record, not string or boolean or date ot time
				for (FieldTypeOptionsEnum option : FieldTypeOptionsEnum.values()) {
					if (!option.equals(FieldTypeOptionsEnum.TEXT_AREA)) {
						fieldTypeBox.addItem(option.getName());
						fieldTypeList.add(option.getName());
					}
				}
				// default
				if (field.getFieldType() != 0) {
					int index = fieldTypeList.indexOf(FieldTypeOptionsEnum.fromId(field.getFieldType()).getName());
					fieldTypeBox.setSelectedIndex(index);
				}
			}
		} else {// new record
			for (FieldTypeOptionsEnum option : FieldTypeOptionsEnum.values()) {
				fieldTypeBox.addItem(option.getName());
				fieldTypeList.add(option.getName());
			}
			// default
			fieldTypeBox.setSelectedIndex(0);
			field.setFieldType(FieldTypeOptionsEnum.TEXT_BOX.getId());
		}

		fieldTypeBox.addChangeListener(new ChangeListener() {

			@Override
			public void onChange(Widget sender) {
				int index = fieldTypeBox.getSelectedIndex();
				String value = fieldTypeBox.getValue(index);
				field.setFieldType(FieldTypeOptionsEnum.fromName(value).getId());

			}
		});

	}

	private void setResizeSize(int height, int width, ScrollPanel assetScroll) {
		int heightAll = Window.getClientHeight() - SCROLL_CUT - messageContainer.getOffsetHeight() - SCROLL_CUT_BOTTOM;
		dataScroll.setHeight(String.valueOf(heightAll) + "px");
		dataScroll.setWidth(String.valueOf(Window.getClientWidth() < 900 ? 900 : Window.getClientWidth() - SCROLL_WIDTH_CUT) + "px");

		SimplePanel assetPanel = (SimplePanel) assetScroll.getWidget();
		assetPanel.setWidth(String.valueOf(220) + "px");
		int assetPanelHeight = Window.getClientHeight() - SCROLL_CUT - messageContainer.getOffsetHeight() - SCROLL_CUT_BOTTOM;
		assetPanel.setHeight(String.valueOf(assetPanelHeight) + "px");
		int assetScrollHeight = Window.getClientHeight() < 650 ? assetPanelHeight + 10 : assetPanelHeight;
		assetScroll.setHeight(String.valueOf(assetPanelHeight + 10) + "px");

	}

	private void addFieldTableRow(FlexTable fieldsTable, UICustomField uiCustomField) {
		int row = fieldsTable.getRowCount() + 1;
		setFieldTableRow(uiCustomField, row, fieldsTable);

	}

	public MessageArea getMessageContainer() {
		return messageContainer;
	}

	public void setMessageContainer(MessageArea messageContainer2) {
		this.messageContainer = messageContainer2;
	}

}