package com.tandbergtv.cms.portal.content.client.customfield.view;

import java.util.ArrayList;
import java.util.List;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.content.client.customfield.enums.CustomFieldDataType;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomField;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldAsset;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldAssetTree;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldGroup;
import com.tandbergtv.cms.portal.content.client.customfield.rpc.ICustomFieldViewService;
import com.tandbergtv.cms.portal.content.client.customfield.rpc.ICustomFieldViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.customfield.util.CustomFieldUtil;
import com.tandbergtv.cms.portal.content.client.exception.BasicSearchFieldValidationException;
import com.tandbergtv.cms.portal.content.client.exception.CustomFieldDeleteValidationException;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.ui.title.client.model.search.MessageContainer;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class CustomFieldTabView extends Composite {
	private final SimpleContainer rootContainer;
	private SimplePanel assetsViewPanel;
	private ScrollPanel assetScroll;
	private HorizontalPanel windowPanel;
	private List<UICustomFieldGroup> groupsModified;
	private static final String STYLE_TREEITEM_SELECTED = "sites-treeItem-selected";
	private static final int ASSET_CUT = 235;
	private ICustomFieldViewServiceAsync viewService;
	private CustomFieldGroupsView groupsView;
	

	private MessageArea messageContainer;
	private Tree tree;
	UICustomFieldAssetTree assetTree = null;

	private ContentConstants myConstants = (ContentConstants) GWT
			.create(ContentConstants.class);
	// Busy indicator.
	private BusyIndicator busyIndicator;

	// UIAsset asset = getRootAsset();
	public CustomFieldTabView(MessageArea messageArea) {
		this.messageContainer = messageArea;
		this.messageContainer.reset();
		
		groupsModified = new ArrayList<UICustomFieldGroup>();
		// com.google.gwt.user.client.Window.Location.reload();
		busyIndicator = new BusyIndicator();
		rootContainer = new SimpleContainer();
		
		this.initWidget(rootContainer);
		initialize();

	}

	private void initialize() {
		this.viewService = GWT.create(ICustomFieldViewService.class);
		initTree();

	}

	

	private void initTree() {
		this.showBusyIndicator();
		groupsView = null;
		viewService.getUIAssetTree(new AsyncCallback<UICustomFieldAssetTree>() {

			@Override
			public void onFailure(Throwable caught) {
				hideBusyindicator();
				String error = (caught != null) ? caught.getLocalizedMessage()
						: "";
				Window.alert("Error retrieving asset tree: " + error);

			}

			@Override
			public void onSuccess(UICustomFieldAssetTree result) {
				assetTree = result;
				buildAssetPanel(result, true);
				hideBusyindicator();

			}

		});

	}

	private void buildAssetPanel(UICustomFieldAssetTree result, boolean refresh) {
		UICustomFieldAsset pkgAsset = result.getPkgAsset();
		UICustomFieldAsset seriesAsset = result.getSeriesAsset();
		assetScroll = new ScrollContainer();
		assetsViewPanel = new SimplePanel();
		assetsViewPanel.addStyleName("AssetsViewPanel");
		

		assetScroll.add(assetsViewPanel);
		
		assetScroll.setAlwaysShowScrollBars(false);
		

		
		// add style
		tree = new Tree();
		
		TreeItem rootItem = buildAssetTree(pkgAsset);
		if (rootItem == null) {
			showError("Invalid specification for package");
			return;
		}
		tree.addItem(rootItem);
		rootItem.setState(true, false);
		tree.setSelectedItem(rootItem);
		tree.addSelectionHandler(new SelectionHandler<TreeItem>() {
			@Override
			public void onSelection(SelectionEvent<TreeItem> event) {

				showAssetPanel(event.getSelectedItem(), false);

			}
		});

		TreeItem series = buildSeriesAssetTree(seriesAsset);
		tree.addItem(series);
		series.setState(true, false);

		if (series == null) {
			showError("Invalid specification for series");
			return;
		}
		assetsViewPanel.add(tree);

		// Show root asset.
		showAssetPanel(tree.getItem(0), refresh);
	}

	private TreeItem buildSeriesAssetTree(UICustomFieldAsset seriesAsset) {
		TreeItem item = new TreeItem(seriesAsset.getDisplayName());
		item.setUserObject(seriesAsset);
		// if children
		if (seriesAsset.getAssetList() != null
				&& !seriesAsset.getAssetList().isEmpty()) {
			addSeriesTreeChildren(seriesAsset, item);
		}
		return item;

	}

	private void showAssetPanel(TreeItem item, boolean refresh) {
		List<UICustomFieldGroup> currentList = new ArrayList<UICustomFieldGroup>();
		if (groupsView != null) {

			currentList = groupsView.getAssetDisplayed().getGroupList();
		}

		UICustomFieldAsset asset = (UICustomFieldAsset) item.getUserObject();

		if (groupsModified == null) {
			groupsModified = new ArrayList<UICustomFieldGroup>();
		}
		for (UICustomFieldGroup group : currentList) {
			if (!groupsModified.contains(group)) {
				groupsModified.add(group);
			}

		}

		groupsView = new CustomFieldGroupsView(asset, refresh, assetScroll, messageContainer);
		
		windowPanel = new HorizontalPanel();
	//	windowPanel.setWidth("400px");
		windowPanel.add(assetScroll);
		windowPanel.add(groupsView);
	//	windowPanel.setSpacing(4);
		rootContainer.setWidget(windowPanel);
		
	}

	public void showError(String error) {
		rootContainer.setWidget(new Label(error));
	}

	private TreeItem buildAssetTree(UICustomFieldAsset uiAsset) {
		TreeItem item = new TreeItem(uiAsset.getDisplayName());
		item.setUserObject(uiAsset);
		// if children
		if (uiAsset.getAssetList() != null && !uiAsset.getAssetList().isEmpty()) {
			addTreeChildren(uiAsset, item);
		}
		return item;
	}

	private void addSeriesTreeChildren(UICustomFieldAsset uiAsset, TreeItem item) {
		List<UICustomFieldAsset> assetList = uiAsset.getAssetList();
		for (UICustomFieldAsset asset : assetList) {
			String assetName = asset.getDisplayName();
			if (assetName.equalsIgnoreCase("Season")) {
				TreeItem child = new TreeItem(asset.getDisplayName());
				//child.addStyleName(STYLE_TREEITEM);
				if (child.isSelected()) {
					child.addStyleName(STYLE_TREEITEM_SELECTED);
				} else {
					child.removeStyleName(STYLE_TREEITEM_SELECTED);
				}
				item.addItem(child);
				child.setUserObject(asset);
				if (asset.getAssetList() != null
						&& !asset.getAssetList().isEmpty()) {
					addSeriesTreeChildren(asset, child);
				}

			}
		}

	}

	private void addTreeChildren(UICustomFieldAsset uiAsset, TreeItem item) {
		List<UICustomFieldAsset> assetList = uiAsset.getAssetList();
		for (UICustomFieldAsset asset : assetList) {

			TreeItem child = new TreeItem(asset.getDisplayName());
			//child.addStyleName(STYLE_TREEITEM);
			if (child.isSelected()) {
				child.addStyleName(STYLE_TREEITEM_SELECTED);
				child.setWidth("100%");
			} else {
				child.removeStyleName(STYLE_TREEITEM_SELECTED);
			}
			item.addItem(child);
			child.setUserObject(asset);
			if (asset.getAssetList() != null && !asset.getAssetList().isEmpty()) {
				addTreeChildren(asset, child);
			}

		}

	}

	public void addGroupsModified(UICustomFieldGroup group) {
		if (groupsModified == null) {
			groupsModified = new ArrayList<UICustomFieldGroup>();
		}
		groupsModified.add(group);
	}

	public List<UICustomFieldGroup> getGroupsModified() {
		return groupsModified;
	}

	public void setGroupsModified(List<UICustomFieldGroup> groupsModified) {
		this.groupsModified = groupsModified;
	}

	public void saveGroups() {
		if (groupsModified != null && !groupsModified.isEmpty()) {
			viewService.saveGroups(groupsModified,
					new NeptuneAsyncCallback<Void>() {
						@Override
						public void onNeptuneFailure(Throwable caught) {
							messageContainer.setErrorMessage("Save error: "
									+ caught.getMessage());
						}

						@Override
						public void onNeptuneSuccess(Void result) {
							messageContainer.setInfoMessage(
									"Custom Field Groups were saved");

							groupsModified = null;
							initTree();

						}
					});

		}

	}

	public boolean saveAll() {
		showBusyIndicator();
		List<UICustomFieldGroup> groupList = getAllAssetGroups();
		if (!validateAll(groupList)) {
			hideBusyindicator();
			return false;

		}
		viewService.saveGroups(groupList, new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				if(caught instanceof CustomFieldDeleteValidationException){
					
					messageContainer.setErrorMessage("Save error: " +caught.getMessage() );
					initTree();
				}
				else {
				messageContainer.setErrorMessage("Save error: " + caught.getMessage());
				}
				hideBusyindicator();		
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				messageContainer.setInfoMessage(
						"Custom Field Groups were saved successfully.");

				initTree();
				hideBusyindicator();
			}
		});
		
		return true;
	}

	public boolean checkLatestGroups() {
		List<UICustomFieldGroup> currentList = new ArrayList<UICustomFieldGroup>();
		if (groupsView != null) {

			currentList = groupsView.getAssetDisplayed().getGroupList();
		}
		if (CustomFieldUtil.hasDuplicate(currentList)) {
			List<UICustomFieldGroup> duplicates = CustomFieldUtil
					.getDuplicate(currentList);
			String duplStr = CustomFieldUtil.getDuplicateMessage(duplicates);
			messageContainer
					.setErrorMessage(
							myConstants.groupDisplayNameAlreadyExists() + " "
									+ duplStr);
			return false;
		}
		if (!validateUniqueCustomFieldName(currentList)) {
			return false;
		}
		if (groupsModified == null) {
			groupsModified = new ArrayList<UICustomFieldGroup>();
		}

		for (UICustomFieldGroup group : currentList) {
			if (!groupsModified.contains(group)) {
				groupsModified.add(group);
			}

		}

		return true;
	}

	private boolean validateUniqueCustomFieldName(
			List<UICustomFieldGroup> currentList) {
		List<UICustomField> fieldList = new ArrayList<UICustomField>();
		if (currentList != null) {
			for (UICustomFieldGroup group : currentList) {
				List<UICustomField> list = group.getFieldList();
				if (list != null) {
					fieldList.addAll(list);
				}
			}
		}
		resetList(fieldList);
		//check for file values.
		
		for(UICustomField field: fieldList) {
			if(field.getName()!= null && (field.getName().equalsIgnoreCase("lookupkey") || field.getName().equalsIgnoreCase("materialid") || 
					field.getName().equalsIgnoreCase("encodeformat") || field.getName().equalsIgnoreCase("encodeprofile"))) {
				messageContainer.setErrorMessage(myConstants.wrongCustomFieldValue() + " " + field.getName() + " for Asset " + field.getAssetPath());
				return false;
			}
		}
			
		
		if (CustomFieldUtil.hasDuplicate(fieldList)) {
			List<UICustomField> duplicates = CustomFieldUtil
					.getDuplicate(fieldList);
			String duplString = CustomFieldUtil
					.getDuplicatesMessage(duplicates);
			
			
			messageContainer.setErrorMessage(
					myConstants.customFieldNameAlreadyExists() + " "
							+ duplString);
			
			return false;
		}

		for(UICustomField field: fieldList) {
			if(field.isDuplFlag()) {
				//diff asset , same name, diff datatype
				messageContainer.setErrorMessage(
						myConstants.customFieldDiffAssetDiffDatatype() + " " + " Asset : " + field.getAssetPath() + " Name: " + field.getName() );
				return false;
			}
		}
		return true;
	}

	
	private void resetList(List<UICustomField> fieldList) {
		for(UICustomField field: fieldList) {
			field.setDuplFlag(false);
		}
		
	}

	public boolean validate() {
		boolean token = true;
		messageContainer.reset();
		if (groupsModified != null && !groupsModified.isEmpty()) {
			for (UICustomFieldGroup group : groupsModified) {
				// if empty displayName
				if (group.getDisplayName() == null
						|| group.getDisplayName().trim().isEmpty()) {
					messageContainer.setErrorMessage(
							myConstants.emptyCustomFieldGroupDisplayName()
									+ ": " + group.getAssetPath());

					token = false;

				}
				if (!validateFields(group)) {
					token = false;
				}

			}
		}

		return token;
	}

	private boolean validateFields(UICustomFieldGroup group) {
		boolean valid = true;
		List<UICustomField> fieldsList = group.getFieldList();
		if (fieldsList != null) {
			for (UICustomField field : fieldsList) {
				if (field.getName() == null || field.getName().trim().isEmpty()) {
					if (fieldsList.indexOf(field) != -1 && fieldsList.indexOf(field) != (fieldsList.size() - 1)) { // not last row
																				
						messageContainer.setErrorMessage(
								myConstants.emptyCustomFieldName() + ": "
										+ group.getAssetPath());
						valid = false;
					}
					else {
						//last row if anything populated
						if(!field.getDataType().equals(CustomFieldDataType.STRING.toString()) ||
								field.getFieldType() != 1 || field.isJobParameter() || field.isJobScheduleParameter()) { //mistakenly populated
							messageContainer.setErrorMessage(
									myConstants.emptyCustomFieldName() + ": "
											+ group.getAssetPath());
							valid = false;
						}
					}
				}
				else {
					if(validateSpecialChars(field.getName())) {
						messageContainer.setErrorMessage(
								myConstants.specialCharsName() + " Asset : " + field.getAssetPath() + " Name: " + field.getName());
						valid = false;
										
					}
				}
				
				if (field.getDisplayName() == null
						|| field.getDisplayName().trim().isEmpty()) {
					if (fieldsList.indexOf(field) != -1 && fieldsList.indexOf(field) != (fieldsList.size() - 1)) { // ignore last row
						messageContainer.setErrorMessage(
								myConstants.emptyCustomFieldDisplayName()
										+ ": " + group.getAssetPath());
						valid = false;
					}
					else {
						//last row
						if(!field.getDataType().equals(CustomFieldDataType.STRING.toString()) ||
								field.getFieldType() != 1 || field.isJobParameter() || field.isJobScheduleParameter()) { //mistakenly populated
							messageContainer.setErrorMessage(
									myConstants.emptyCustomFieldDisplayName()
											+ ": " + group.getAssetPath());
							valid = false;
						}
					}
				}
				if(field.getName() != null) {
					field.setName(field.getName().trim()); //if all validation passed, just trim the name
				}
			}
		}

		return valid;
	}

	private boolean validateSpecialChars(String name) {
		//ignore wite spaces
		String trimmedName = name.replace(" ", "");
		trimmedName.trim();
		if(!trimmedName.matches("^[a-zA-Z0-9_-]*$")) {
			return true;
		}
		return false;
	}

	/**
	 * Shows busy indicator
	 */
	public void showBusyIndicator() {
		busyIndicator.center();
	}

	/**
	 * Hides busy indicator
	 */
	public void hideBusyindicator() {
		busyIndicator.hide();
	}

	public void refresh() {
		// TODO Auto-generated method stub

	}

	// check for duplicates
	public boolean hasErrors() {
		if (groupsModified != null) {
			if (CustomFieldUtil.hasDuplicate(groupsModified)) {

				messageContainer.setErrorMessage(
						myConstants.groupDisplayNameAlreadyExists());
				return true;
			}

		}
		return false;
	}

	public void clearAll() {
		messageContainer.reset();
		groupsModified = null;
		initTree();

	}

	public boolean validateAll(List<UICustomFieldGroup> groupList) {
		boolean status = true;

		// check for duplicates
		if (CustomFieldUtil.hasDuplicate(groupList)) {
			List<UICustomFieldGroup> duplicates = CustomFieldUtil
					.getDuplicate(groupList);
			String duplStr = CustomFieldUtil.getDuplicateMessage(duplicates);
			messageContainer
					.setErrorMessage(
							myConstants.groupDisplayNameAlreadyExists() + " "
									+ duplStr);
			status = false;
		}
		if (!validateUniqueCustomFieldName(groupList)) {
			status = false;
		}
		// check for null values
		for (UICustomFieldGroup group : groupList) {
			// if empty displayName
			if (group.getDisplayName() == null
					|| group.getDisplayName().trim().isEmpty()) {
				messageContainer.setErrorMessage(
						myConstants.emptyCustomFieldGroupDisplayName() + ": "
								+ group.getAssetPath());

				status = false;

			}
			if (!validateFields(group)) {
				status = false;
			}

		}
		return status;
	}

	private List<UICustomFieldGroup> getAllAssetGroups() {
		List<UICustomFieldGroup> groupList = new ArrayList<UICustomFieldGroup>();

		if (tree != null) {
			int count = tree.getItemCount();
			for (int i = 0; i < count; i++) {
				TreeItem item = tree.getItem(i);

				UICustomFieldAsset asset = (UICustomFieldAsset) item
						.getUserObject();
				if (asset.getGroupList() != null) {
					groupList.addAll(asset.getGroupList());
				}
				traverse(item, groupList);
			}

		}
		return groupList;
	}

	public void traverse(TreeItem item, List<UICustomFieldGroup> groupList) {
		for (int i = 0; i < item.getChildCount(); i++) {
			TreeItem child = item.getChild(i);
			UICustomFieldAsset asset = (UICustomFieldAsset) child
					.getUserObject();
			if (asset.getGroupList() != null) {
				groupList.addAll(asset.getGroupList());
			}
			traverse(child, groupList);
		}
	}
	public CustomFieldGroupsView getGroupsView() {
		return groupsView;
	}

}
