package com.tandbergtv.cms.portal.content.client.lookupkey.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UiLookupKey implements IsSerializable {

    public static final String ORIGINAL_LOOKUP_KEY = "ORIGINAL";
    private Long key;
    private String name;
    private String description;
    private boolean readOnly;
    private List<UiAssetType> assetTypes;

    /**
     * Constructor
     */
    public UiLookupKey() {
        assetTypes = new ArrayList<UiAssetType>();
    }

    public Long getKey() {
        return key;
    }

    public void setKey( Long key ) {
        this.key = key;
    }

    public String getName() {
        return name;
    }

    public void setName( String name ) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription( String description ) {
        this.description = description;
    }

    public void setReadOnly( boolean readOnly ) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return readOnly;
    }

    public void setAssetTypes( List<UiAssetType> assetTypes ) {
        this.assetTypes = assetTypes;
    }

    public List<UiAssetType> getAssetTypes() {
        return assetTypes;
    }

    public String getAssetTypesAsString() {
        StringBuilder assetTypesSB = new StringBuilder();
        Collections.sort( assetTypes, new Comparator<UiAssetType>() {

            @Override
            public int compare( UiAssetType o1, UiAssetType o2 ) {
                return o1.getDisplayName().compareTo( o2.getDisplayName() );
            }
        });
        
        for ( int x = 0; x < assetTypes.size(); x++ ) {
            assetTypesSB.append( assetTypes.get( x ).getDisplayName() );
            if ( x < assetTypes.size() - 1 ) {
                assetTypesSB.append( ", " );
            }
        }

        return assetTypesSB.toString();
    }

}
