package com.tandbergtv.cms.portal.content.client.lookupkey.view;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class LimitedLabelStringView extends LabelStringView {

    public LimitedLabelStringView( String value, int sizeLimit ) {
        super( value );
        this.getWidget().setTitle( value );
        limitLabelText( sizeLimit );
    }

    private void limitLabelText( int sizeLimit ) {
        String text = label.getText();
        if ( (sizeLimit > 0) && (text.length() > sizeLimit) ) {
            text = text.substring( 0, sizeLimit - 1 );
            text += "...";
        }
        label.setText( text );
    }

}
