package com.tandbergtv.cms.portal.content.client.lookupkey.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyService;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class LookupKeyAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?lookupKeyId=1
    private static String LOOKUP_KEY_ID = "lookupKeyId";
    private static String PARAMETER_DELIMITER = "&";
    private static String VALUE_DELIMITER = "=";
    private final LookupKeysListPanel widget;

    public LookupKeyAnchorChangeListener( LookupKeysListPanel lookupKeysListPanel ) {
        this.widget = lookupKeysListPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {
        long lookupKeyId = 0L;

        /* Ensure that the widget state is cleaned up */
        widget.cleanup();

        /* Check for anchor with lookup key id */
        if ( anchor != null && anchor.contains( LOOKUP_KEY_ID ) ) {
            widget.getLookupKeysTable().reset();

            // skip the first char
            anchor = anchor.substring( 1 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( LOOKUP_KEY_ID ) ) {
                    lookupKeyId = Long.parseLong( paramValue[1] );
                }
            }

            // get the lookup key from the server.
            ILookupKeyServiceAsync lookupKeyService = GWT.create( ILookupKeyService.class );
            lookupKeyService.get( lookupKeyId, new NeptuneAsyncCallback<UiLookupKey>() {
                public void onNeptuneFailure( Throwable caught ) {
                    Window.alert( caught.getLocalizedMessage() );
                }

                public void onNeptuneSuccess( UiLookupKey result ) {
                    widget.getLookupKeysTable().showDetailView( new UiLookupKeyRecord( result ) );
                }
            } );
        } else {
            widget.getLookupKeysTable().setAnchor( anchor );
        }
    }
}
