package com.tandbergtv.cms.portal.content.client.lookupkey.view;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyService;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * Handles detail view for a given lookup key.
 * 
 * @author Daniel Paranhos
 * 
 */
public class LookupKeyDetailFeature extends AbstractDetailFeature<Long, UiLookupKeyRecord> {

    private LookupKeysListPanel parentPanel;

    private ILookupKeyServiceAsync lookupKeyService = GWT.create( ILookupKeyService.class );

    private ContentConstants constants = (ContentConstants) GWT.create( ContentConstants.class );

	private LookupKeyDetailView detailView;

    public LookupKeyDetailFeature( LookupKeysListPanel parentPanel ) {
        super( new UiLookupKeyKeySerializer() );
        this.parentPanel = parentPanel;
    }

    @Override
    public void delete( final List<UiLookupKeyRecord> records, final AsyncCallback<Void> callback ) {
        callback.onFailure( new NeptuneException( "LookupKey delete is not allowed" ) );
    }

    @Override
    public void getNew( AsyncCallback<UiLookupKeyRecord> callback ) {
        UiLookupKeyRecord record = new UiLookupKeyRecord( new UiLookupKey() );
        callback.onSuccess( record );
    }

    @Override
    public DetailView<Long, UiLookupKeyRecord> getView( UiLookupKeyRecord record,
            DetailViewCallback<Long, UiLookupKeyRecord> callback ) {
        parentPanel.cleanup();
        detailView = new LookupKeyDetailView( record, callback, parentPanel );

        return detailView;
    }

    /*
     * The detail link is shown only if the user has asset view permissions and
     * the column is the name column.
     */
    @Override
    public boolean hasDetailLink( Column<?, UiLookupKeyRecord> column ) {
        return column.getDisplayName().equals( constants.lookupKeyNameColumn() )
                && NeptuneApplication.getApplication().getSecurity().isUserInRole( Permissions.LOOKUP_KEY_VIEW );
    }

    @Override
    public void save( UiLookupKeyRecord record, final AsyncCallback<Void> callback ) {
        lookupKeyService.save( record.getLookupKey(), new NeptuneAsyncCallback<UiLookupKey>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
                callback.onFailure( caught );
            }

            @Override
            public void onNeptuneSuccess( UiLookupKey result ) {
                callback.onSuccess( null );
            }
        } );
    }

    @Override
    public boolean showCreateButton() {
        return false;
    }

    @Override
    public boolean showDeleteButton() {
        return false;
    }

	public LookupKeyDetailView getDetailView() {
		return detailView;
	}
    
}
