package com.tandbergtv.cms.portal.content.client.lookupkey.view;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiAssetType;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyService;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.SimpleListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class LookupKeyDetailView implements DetailView<Long, UiLookupKeyRecord> {

    private static final String SHUFFLE_BOX = "asset-type-shuffle";
    private static final String LIST_BOX = "asset-type-shuffle-list-box";
    private static final String MOVE_RIGHT_BUTTON = "asset-type-shuffle-button";

    private ContentConstants constants = GWT.create( ContentConstants.class );

    private final UiLookupKeyRecord record;

    private final TextBoxWidget nameTextBox = new TextBoxWidget();

    // description widget
    private TextAreaWidget descriptionTextArea;
    private int DESCRIPTION_VISIBLE_COUNT = 5;
    private int DESCRIPTION_CHAR_WIDTH = 40;

    private HorizontalPanel shuffleBox;
    private SimpleListBoxWidget rightList;
    private SimpleListBoxWidget leftList;

    private final FormContainer formContainer = new FormContainer( HasHorizontalAlignment.ALIGN_LEFT );

    private final VerticalContainer mainContainer = new VerticalContainer();

	private LookupKeysListPanel parentPanel;
	private DetailViewCallback<Long, UiLookupKeyRecord> callback;

    public LookupKeyDetailView( final UiLookupKeyRecord record,
            			  final DetailViewCallback<Long, UiLookupKeyRecord> callback,
            			  final LookupKeysListPanel parentPanel) {
        this.record = record;
        
        nameTextBox.setText( record.getLookupKey().getName() );
        formContainer.addRow( constants.lookupKeyNameColumn(), nameTextBox, true );

        descriptionTextArea = new TextAreaWidget();
        descriptionTextArea.setCharacterWidth( DESCRIPTION_CHAR_WIDTH );
        descriptionTextArea.setVisibleLines( DESCRIPTION_VISIBLE_COUNT );
        descriptionTextArea.setText( record.getLookupKey().getDescription() );
        formContainer.addRow( constants.lookupKeyDescriptionColumn(), descriptionTextArea, true );

        shuffleBox = createShuffleBox();
        formContainer.addRow( constants.lookupKeyAssetTypesColumn(), shuffleBox, false );

        this.parentPanel = parentPanel;
        this.callback = callback;
        updateWidgetsAccess();
    }
    
    public void save() {
    	parentPanel.getResizableContainer().setErrorMessage(null);
        callback.save( LookupKeyDetailView.this );
    }
    
    public void cancel() {
    	parentPanel.getResizableContainer().setErrorMessage(null);
        callback.cancel( LookupKeyDetailView.this );
    }

    private void updateWidgetsAccess() {
        boolean isCreating = record.getKey() == null;
        nameTextBox.setReadOnly( !isCreating );
        
        if (saveButtonIsVisible( isCreating )) {
        	parentPanel.showSaveButton();
        } else {
        	parentPanel.hideSaveButton();
        }
        parentPanel.showCancelButton();
    }

    private boolean saveButtonIsVisible( boolean isCreating ) {
        boolean visible = !record.getLookupKey().isReadOnly();

        if ( visible ) {
            visible = ( isCreating && ClientAuthorizationManager.isAuthorized( Permissions.LOOKUP_KEY_CREATE ) ) 
                        ||  ( !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.LOOKUP_KEY_MODIFY ) );
        }
        return visible;
    }

    private HorizontalPanel createShuffleBox() {
        HorizontalPanel shufflePanel = new HorizontalPanel();
        shufflePanel.setStyleName( SHUFFLE_BOX );

        rightList = new SimpleListBoxWidget( true );
        rightList.setStyleName( LIST_BOX );
        leftList = new SimpleListBoxWidget( true );
        leftList.setStyleName( LIST_BOX );
        
        ButtonWidget moveRightButton = new ButtonWidget();
        moveRightButton.addStyleName( MOVE_RIGHT_BUTTON );
        moveRightButton.setText( ">" );
        moveRightButton.addClickHandler( new ClickHandler() {
            @Override
            public void onClick( ClickEvent event ) {
                for ( int index = leftList.getItemCount() - 1; index >= 0; index-- ) {
                    if ( leftList.isItemSelected( index ) ) {
                        int selectedIndex = leftList.getSelectedIndex();
                        String assetDisplayName = leftList.getItemText( selectedIndex );
                        String assetName = leftList.getValue( selectedIndex );
                        leftList.removeItem( selectedIndex );
                        rightList.addItem( assetDisplayName, assetName );
                    }
                }
            }
        } );

        VerticalPanel leftListContainer = createListBoxContainer( constants.notAssociated() );
        leftListContainer.add( leftList );
        VerticalPanel rightListContainer = createListBoxContainer( constants.associated() );
        rightListContainer.add( rightList );

        shufflePanel.add( leftListContainer );
        shufflePanel.add( moveRightButton );
        shufflePanel.add( rightListContainer );
        shufflePanel.setCellVerticalAlignment( moveRightButton, HasVerticalAlignment.ALIGN_MIDDLE );
        shufflePanel.setSpacing( 5 );

        ILookupKeyServiceAsync lookupKeyService = GWT.create( ILookupKeyService.class );
        lookupKeyService.getAllAssetTypes( new NeptuneAsyncCallback<List<UiAssetType>>() {

            @Override
            public void onNeptuneFailure( Throwable caught ) {
            	parentPanel.getResizableContainer().setErrorMessage( constants.retrieveAssetTypesFailure() );
            }

            @Override
            public void onNeptuneSuccess( List<UiAssetType> result ) {
                for ( UiAssetType uiAssetType : result ) {
                    if ( recordContainsAssetType( uiAssetType.getName() ) ) {
                        rightList.addItem( uiAssetType.getDisplayName(), uiAssetType.getName() );
                    } else {
                        leftList.addItem( uiAssetType.getDisplayName(), uiAssetType.getName() );
                    }
                }
            }

        } );

        return shufflePanel;
    }

    private boolean recordContainsAssetType( String name ) {
        boolean contains = false;
        for ( UiAssetType uiAssetType : record.getLookupKey().getAssetTypes() ) {
            if ( uiAssetType.getName().equalsIgnoreCase( name ) ) {
                contains = true;
                break;
            }
        }

        return contains;
    }

    private VerticalPanel createListBoxContainer( String label ) {
        VerticalPanel container = new VerticalPanel();
        container.add( new LabelWidget( label ) );

        return container;
    }

    public void commit() {
        record.getLookupKey().setName((nameTextBox.getText() == null) ? null : nameTextBox.getText().trim());
        record.getLookupKey().setDescription((descriptionTextArea.getText() == null) ? null : descriptionTextArea.getText().trim());

        record.getLookupKey().getAssetTypes().clear();
        int assetTypesCount = rightList.getItemCount();
        if ( assetTypesCount > 0 ) {
            for ( int x = 0; x < assetTypesCount; x++ ) {
                String name = rightList.getValue( x );
                String displayName = rightList.getItemText( x );
                record.getLookupKey().getAssetTypes().add( new UiAssetType( name, displayName ) );
            }
        }
    }

    @Override
    public Widget getWidget() {
        mainContainer.add( formContainer );
        return mainContainer;
    }

    public void revert() {
        nameTextBox.setText( record.getLookupKey().getName() );
        descriptionTextArea.setText( record.getLookupKey().getDescription() );
        leftList.clear();
        rightList.clear();
        for ( UiAssetType uiAssetType : record.getLookupKey().getAssetTypes() ) {
            if ( record.getLookupKey().getAssetTypes().contains( uiAssetType.getName() ) ) {
                rightList.addItem( uiAssetType.getDisplayName(), uiAssetType.getName() );
            } else {
                leftList.addItem( uiAssetType.getDisplayName(), uiAssetType.getName() );
            }
        }
        updateWidgetsAccess();
    }

    public UiLookupKeyRecord getRecord() {
        return record;
    }

    public String getStyleName() {
        return null;
    }

    @Override
    public void saveFailed( Throwable throwable ) {
        if ( throwable instanceof ValidationException ) {
            ValidationException ve = (ValidationException) throwable;
            StringBuffer messagesSB = new StringBuffer("<ul>");
            for ( String message : ve.getValidationMessages() ) {
                messagesSB.append("<li>").append( message ).append( "</li>" );
            }
            messagesSB.append("</ul>");
        	parentPanel.getResizableContainer().setErrorHTML( messagesSB.toString() );
        } else {
        	parentPanel.getResizableContainer().setErrorMessage(throwable.getLocalizedMessage());
        }
    }

    @Override
    public void release() {
    }

}
