package com.tandbergtv.cms.portal.content.client.lookupkey.view;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.LookupKeysDataProvider.IBusyNotifier;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Table that shows the list of lookup keys.
 * 
 * @author Daniel Paranhos
 * 
 */
public class LookupKeysListPanel extends Composite implements IView {

    // table related
    private LookupKeysDataProvider dataProvider;
    private SortFeatureImpl<Long, UiLookupKeyRecord> sortFeature;
    private BookmarkFeature bookmarkFeature;
    private AnchorChangeListener anchorChangeListener;
    private LookupKeyDetailFeature detailFeature;

    // widgets used in this view
    private VerticalContainer mainContainer;
    private Table<Long, UiLookupKeyRecord> table;
    private ListBoxWidget<String> parameterListBox;
    private BusyIndicator busyIndicator = new BusyIndicator();

    private HeaderPanel header;

    private ContentConstants constants = (ContentConstants) GWT.create( ContentConstants.class );
	private ResizableContainer resizableContainer;

    // spacing between the table and message panel
    private static final String STYLE_NAME = "content-LookupKeysPanel";
	private ButtonWidget btnCreate;
	private ButtonWidget saveButton;
	private ButtonWidget cancelButton;

    public LookupKeysListPanel() {
        this.dataProvider = new LookupKeysDataProvider();
        dataProvider.setBusyNotifier( new IBusyNotifier() {
            @Override
            public void startingToBeBusy() {
                busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                busyIndicator.hide();
            }
        } );
        init();
    }

    private void init() {
        initWidgets();
        setContainers();
    }

    private void setContainers() {
        mainContainer.add( header );
        
		resizableContainer.addButton(constants.lookupKeyTabHeading(), btnCreate);
        resizableContainer.addButton(constants.lookupKeyTabHeading(), saveButton );
		resizableContainer.addButton(constants.lookupKeyTabHeading(), cancelButton );
        
        mainContainer.add( resizableContainer );
    }
    
    private void initWidgets() {
        mainContainer = new VerticalContainer();
        mainContainer.setStylePrimaryName( STYLE_NAME );
        this.initWidget( mainContainer );

        header = new HeaderPanel( "" );

        table = new Table<Long, UiLookupKeyRecord>( dataProvider );
        table.addTableViewChangeHandler( new TableViewChangeHandler<Long, UiLookupKeyRecord>() {
            @Override
            public void onShowDetailView( TableDetailViewEvent<Long, UiLookupKeyRecord> event ) {
            	hideCreateButton();
                if ( event.isCreateView() ) {
                    header.setLabel( constants.lookupKeyCreateHeading() );
                } else {
                    header.setLabel( constants.lookupKeyViewEditHeading() + " "
                            + event.getRecord().getLookupKey().getName() );
                }
            }

            @Override
            public void onShowListView( TableViewEvent event ) {
            	showCreateButton();
            	hideSaveButton();
            	hideCancelButton();
                header.setLabel( constants.lookupKeyListHeading() );
            }
        } );

        // sort feature
        sortFeature = new SortFeatureImpl<Long, UiLookupKeyRecord>(
                dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING );
        for ( Column<?, UiLookupKeyRecord> col : dataProvider.getSortColumns() ) {
            sortFeature.addSortableColumn( col );
        }
        dataProvider.setParentSortFeature( sortFeature );

        // bookmark feature
        bookmarkFeature = new BookmarkFeatureImpl();

        // detail feature
        detailFeature = new LookupKeyDetailFeature( this );

        table.addSortFeature( sortFeature );
        table.addBookmarkFeature( bookmarkFeature );
        table.addDetailFeature( detailFeature );

        resizableContainer = new ResizableContainer(table, constants.lookupKeyTabHeading(), null);
		resizableContainer.addHeightOffsettingWidget(header);

		btnCreate = new ButtonWidget(constants.createButton());
		btnCreate.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		if (ClientAuthorizationManager.isAuthorized( Permissions.LOOKUP_KEY_CREATE )) {
			btnCreate.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					table.showCreateView();
				}
			});
		} 
		btnCreate.setVisible(false);
		
        saveButton = new ButtonWidget( constants.saveButtonName(), new ClickHandler() {
            public void onClick( ClickEvent event ) {
            	detailFeature.getDetailView().save();
            }

        } );
        saveButton.addStyleDependentName( StyleNames.COMMIT_BUTTON_STYLE );
        saveButton.setVisible(false);

        cancelButton = new ButtonWidget( constants.cancelButtonName(), new ClickHandler() {
            public void onClick( ClickEvent event ) {
            	detailFeature.getDetailView().cancel();
            }
        } );
        cancelButton.addStyleDependentName( StyleNames.DATALOSS_BUTTON_STYLE );
        cancelButton.setVisible(false);
        
        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
            }
        } );

        anchorChangeListener = new LookupKeyAnchorChangeListener( this );

    }
    
    protected void showCreateButton() {
    	btnCreate.setVisible(ClientAuthorizationManager.isAuthorized( Permissions.LOOKUP_KEY_CREATE ));
	}

    protected void hideCreateButton() {
    	btnCreate.setVisible(false);
	}
    
	public void showSaveButton() {
		saveButton.setVisible(true);
	}
	
	public void hideSaveButton() {
		saveButton.setVisible(false);
	}
	
	public void showCancelButton() {
		cancelButton.setVisible(true);
	}
	
	public void hideCancelButton() {
		cancelButton.setVisible(false);
	}

	Table<Long, UiLookupKeyRecord> getLookupKeysTable() {
        return this.table;
    }

    public void reportFailure( Throwable caught ) {
        // show the error message along with the current state
    	getResizableContainer().setErrorMessage(caught.getMessage());
    	getResizableContainer().setInfoMessage(null);
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    @Override
    public void cleanup() {
    	getResizableContainer().setErrorMessage(null);
    }

    @Override
    public IActionInput getInputToExecution() {
        return null;
    }

    @Override
    public Widget getParentContainer() {
        return mainContainer;
    }

    @Override
    public List<Long> getSeletedRecordIds() {
        List<UiLookupKeyRecord> selectedIds = table.getSelectedRecords();
        List<Long> ids = new ArrayList<Long>();
        for ( UiLookupKeyRecord tr : selectedIds ) {
            ids.add( tr.getKey() );
        }
        return ids;
    }

    @Override
    public void refresh( String infoMessage ) {
        mainContainer.clear();
        setContainers();
        /* Return to the first page and show the updated list view of the table */
        this.table.getPageFeature().setPageNumber( 1 );
        this.table.showListView();
        this.table.refresh();
        this.table.updateAnchor();
        show( infoMessage );
    }

    @Override
    public void show( String infoMessage ) {
        if ( infoMessage != null && !infoMessage.isEmpty() ) {
        	getResizableContainer().setInfoMessage(infoMessage);
        } 
    }

    @Override
    public void show( boolean readOnly ) {
        this.parameterListBox.setEnabled( readOnly );
    }

    /**
     * @param reverseAnchorChangeListener
     *            the reverseAnchorChangeListener to set
     */
    public void setReverseAnchorChangeListener( AnchorChangeListener reverseAnchorChangeListener ) {
        table.setAnchorChangeNotifier( reverseAnchorChangeListener );
    }

	public ResizableContainer getResizableContainer() {
		return resizableContainer;
	}

}
