package com.tandbergtv.cms.portal.content.client.lookupkey.view;

import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Represents a lookup key record in the lookup key list view.
 * 
 * @author Daniel Paranhos
 * 
 */
public class UiLookupKeyRecord implements Record<Long> {

    private UiLookupKey lookupKey;

    public UiLookupKeyRecord() {
    }

    public UiLookupKeyRecord( UiLookupKey lookupKey ) {
        super();
        this.lookupKey = lookupKey;
    }

    @Override
    public Long getKey() {
        return lookupKey.getKey();
    }

    /**
     * @return the lookupKey
     */
    public UiLookupKey getLookupKey() {
        return lookupKey;
    }

    /**
     * @param lookupKey
     *            the lookupKey to set
     */
    public void setLookupKey( UiLookupKey lookupKey ) {
        this.lookupKey = lookupKey;
    }

}
