package com.tandbergtv.cms.portal.content.client.metadataconfig;

import java.util.List;

/**
 * Metadata Configuration Controller interface
 * @param <E> UI model ex. <UiAppType>
 */
public interface IMetadataConfigController<E> {
	/**
	 * Gets lists of items from the server. The retrieved list is then shown in the list section on UI
	 */
	public void getList();

	/**
	 * Gets a single item from server based on supplied primary key(s) 
	 * @param ids
	 */
	public void get(String... ids);
	
	/**
	 * Adds (if not found in system)/updates a single item to the system. Update is not supported at this time.
	 * @param item
	 */
	public void update(E item);
	
	/**
	 * Deletes items from system at server that match the lookup criteria for supploed itemIds. 
	 * @param itemIds
	 */
	public void delete(List<String> itemIds);
}
