package com.tandbergtv.cms.portal.content.client.metadataconfig;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype.AppTypeConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory.ContentAdvisoryConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre.GenreConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product.ProductConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating.RatingConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio.StudioConfigTab;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Lazy View implementation of Metadata Configuration screen.
 */
public class MetadataConfigLazyView extends LazyView {
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	// Root container
	private VerticalPanel verticalPanel;
	private HeaderPanel headerPanel;
	
	/* Internal state */
	private BusyIndicator busyIndicator;
	private static int APPTYPE_TAB_INDEX = 0;
	
	private static final String METADATA_CONFIG_PANEL_STYLE = "content-metadataConfig-panel";
	private static final String METADATA_CONFIG_HEADER_LABEL_STYLE = "content-metadataConfigHeaderWidget-headingLabel";
	
	public static final String TAB_ANCHOR_KEY = "Tab";
	
	private int selectedTab = APPTYPE_TAB_INDEX;

	private ResizableContainer resizableTabContainer;

	@SuppressWarnings("rawtypes")
	private List<MetadataConfigTab> tabs;

	private ButtonWidget btnCreate;

	private ButtonWidget btnDelete;

	private ButtonWidget btnSave;

	private ButtonWidget btnCancel;
	
	/**
	 * Constructor
	 */
	public MetadataConfigLazyView() {
		//Nothing to do here since this is a lazy view
	}
		
	/**
	 * Shows busy indicator and blocks user interactions to the UI.
	 * hideBusyIndicator method must be called once the blocking operation is over.
	 */
	public void showBusyIndicator() {
		busyIndicator.center();
	}
	
	/**
	 * Hides busy indicator and clears 'block' created by showBusyIndicator
	 */
	public void hideBusyIndicator() {	
		busyIndicator.hide();
	}
	
	@Override
	public String getAnchor() {
		AnchorTokenizer tokenizer = new AnchorTokenizer();
		Map<String, String> anchorTokens = new LinkedHashMap<String, String>();
		
		anchorTokens.put(TAB_ANCHOR_KEY, getSelectedTabName());
		return tokenizer.buildAnchor(anchorTokens);
	}
	
	@Override
	protected void setWidgetAnchor(String anchor) {
		AnchorTokenizer tokenizer = new AnchorTokenizer();
		Map<String, String> anchorTokens = tokenizer.parseAnchor(anchor);
		
		String selectedTab = anchorTokens.get(TAB_ANCHOR_KEY);
		//make sure tab name is valid
		if (selectedTab == null) 
			selectedTab = tabs.get(0).getTabName();
		
		selectedTab = selectedTab.trim();
		showTab(selectedTab);
	}

	@SuppressWarnings("rawtypes")
	@Override
	protected Widget createWidget() {		
		/* Build the busy indicator */
		busyIndicator = new BusyIndicator();
		
		verticalPanel = new VerticalPanel();
		verticalPanel.addStyleName(METADATA_CONFIG_PANEL_STYLE);
		
		headerPanel = new HeaderPanel(myConstants.metadataConfigHeaderLabel());
		headerPanel.addStyleName(METADATA_CONFIG_HEADER_LABEL_STYLE);
		verticalPanel.add(headerPanel);


		/* Create the tab container and the tabs */
		tabs = new ArrayList<MetadataConfigTab>();
		
		btnCreate = new ButtonWidget(myConstants.create());
		btnCreate.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE)) {
			btnCreate.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					clearErrors();
					MetadataConfigTab tab = tabs.get(selectedTab);
					tab.showCreatePanel();
				}
			});
		}
		btnCreate.setVisible(false);
		
		btnDelete = new ButtonWidget(myConstants.delete());
		btnDelete.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		if(ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_VIEW, Permissions.METADATA_CONFIG_DELETE)) {
			btnDelete.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					clearErrors();
					MetadataConfigTab tab = tabs.get(selectedTab);
					tab.deleteSelected();
				}
			});
		}
		btnDelete.setVisible(false);
		
		btnSave = new ButtonWidget(myConstants.save());
		btnSave.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE)) {
			btnSave.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					clearErrors();
					MetadataConfigTab tab = tabs.get(selectedTab);
					tab.save();
				}
			});
		}
		btnSave.setVisible(false);
		
		btnCancel = new ButtonWidget(myConstants.cancel());
		btnCancel.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE)) {
			btnCancel.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					clearErrors();
					MetadataConfigTab tab = tabs.get(selectedTab);
					tab.getTable().refresh();
					tab.showListPanel();
				}
			});
		}
		btnCancel.setVisible(false);

		/* App Type Tab */
		addTab(new AppTypeConfigTab(this), myConstants.appTypeTabName());
		/* Content Advisory Tab */
		addTab(new ContentAdvisoryConfigTab(this), myConstants.contentAdvisoryTabName());
		/* Genre Tab */
		addTab(new GenreConfigTab(this), myConstants.genreTabName());
		/* Product Tab */
		addTab(new ProductConfigTab(this), myConstants.productTabName());
		/* Rating Tab */
		addTab(new RatingConfigTab(this), myConstants.ratingTabName());
		/* Studio Tab */
		addTab(new StudioConfigTab(this), myConstants.studioTabName());
		
		resizableTabContainer.addHeightOffsettingWidget(headerPanel);

		MetadataConfigTabEventHandler handler = new MetadataConfigTabEventHandler();
		
		resizableTabContainer.addSelectionHandler(handler);
		resizableTabContainer.selectTab(myConstants.appTypeTabName());

		verticalPanel.add(resizableTabContainer);
		return verticalPanel;
	}
	
	@SuppressWarnings("rawtypes")
	protected void addTab(MetadataConfigTab tab, String tabname) {
		if (resizableTabContainer == null) {
			resizableTabContainer = new ResizableContainer(tab, tabname, null);
		} else {
			resizableTabContainer.addTab(tab, tabname);
		}
		tab.setTabName(tabname);
		tabs.add(tab);
	}
	
	/*
	 * Get the tab index specified in the title view input
	 */
	private int getSelectedTabIndex() {
		return selectedTab;
	}

	@SuppressWarnings("rawtypes")
	private String getSelectedTabName() {
		int index = getSelectedTabIndex();
		Widget widget = tabs.get(index);
		String tabName = null;
		if (widget instanceof MetadataConfigTab) {
			tabName = ((MetadataConfigTab) widget).getTabName();
		}
		return tabName;
	}
	
	/*
	 * Update the display for the tab if the specified tab state is stale
	 */
	@SuppressWarnings("rawtypes")
	private void updateTab(int tabIndex) {
		Widget widget = tabs.get(tabIndex);
		if (widget instanceof MetadataConfigTab) {
			MetadataConfigTab tab = (MetadataConfigTab) widget;
			//refresh panel which will internally clear errors
			tab.refresh();
		}
	}

	// ========================================================================
	// ===================== TAB SELECTION
	// ========================================================================

	/**
	 * Switch to tab with given tab name (if not already displayed)
	 * 
	 * @param tabName The tab name
	 */
	@SuppressWarnings("rawtypes")
	private void showTab(String tabName) {
		MetadataConfigTab tab = getTab(tabName);
		resizableTabContainer.selectTab(tabName);
		tab.refresh();
	}

	/**
	 * Getter for individual tab based on unique tabName assigned to that tab.
	 * @param tabName
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public MetadataConfigTab getTab(String tabName) {
		for (MetadataConfigTab tab : tabs) {
			if (tab.getTabName().equals(tabName)) {
				return tab;
			}
		}
		return null;
	}
	
	/*
	 * Fire an anchor change event
	 */
	protected void fireViewAnchorChange() {
		String anchor = getAnchor();
		fireEvent(new ViewAnchorChangeEvent(anchor));
	}
	
	private class MetadataConfigTabEventHandler implements SelectionHandler<Integer> {
		@Override
		public void onSelection(SelectionEvent<Integer> event) {
			/* Notify the tab of selection and update the input */
			selectedTab = event.getSelectedItem();
			fireViewAnchorChange();
			resizableTabContainer.addButton(tabs.get(selectedTab).getTabName(), btnCreate);
			resizableTabContainer.addButton(tabs.get(selectedTab).getTabName(), btnDelete);
			resizableTabContainer.addButton(tabs.get(selectedTab).getTabName(), btnSave);
			resizableTabContainer.addButton(tabs.get(selectedTab).getTabName(), btnCancel);
			
			updateTab(event.getSelectedItem());
		}

	}
	
	public void setError(String message) {
		resizableTabContainer.getMessageArea().setErrorMessage(message);
		resizableTabContainer.updateSize();
	}
	
	public void setWarning(String warning) {
		resizableTabContainer.getMessageArea().setInfoMessage(warning);
		resizableTabContainer.updateSize();
	}

	public void showListViewButtons() {
		btnCreate.setVisible(ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE));
		btnDelete.setVisible(ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_VIEW, Permissions.METADATA_CONFIG_DELETE));
		btnCancel.setVisible(false);
		btnSave.setVisible(false);
	}
	
	public void showManageViewButtons() {
		btnCreate.setVisible(false);
		btnDelete.setVisible(false);
		btnCancel.setVisible(ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE));
		btnSave.setVisible(ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE));
	}
	/**
	 * Clears the errors/warnings displayed in List as well as Create sections
	 */
	public void clearErrors() {
		resizableTabContainer.setErrorMessage(null);
		resizableTabContainer.setInfoMessage(null);
	}

}
