package com.tandbergtv.cms.portal.content.client.metadataconfig;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * An abstract class representing individual metadata configuration tabs
 *
 * @param <E>	UI Related model ex. <UiAppType>
 * @param <K>	Search key for the <E> model <String> 
 * @param <R>	UI Record - a wrapper to <E> such that <R> is and extenstion of Record<K>
 */
public abstract class MetadataConfigTab<E, K, R extends Record<K>> extends Composite {
	protected MetadataConfigConstants constants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	private static final String TAB_CONTAINERPANEL_STYLE = "content-metadataConfigTab-scrollContainer";
	protected static final String TEXT_AREA_STYLE = "content-metadataConfigTab-textArea";
	protected static final String TEXT_BOX_SHORT_STYLE = "content-metadataConfigTab-shortText";
	protected static final String TEXT_BOX_LONG_STYLE = "content-metadataConfigTab-longText";
	
	protected IMetadataConfigController<E> controller;

	protected SimpleContainer panel;
	
	protected Table<K, R> table;
	protected LabelWidget rowCountLabel;
	
	protected String tabName; 
	
	protected VerticalPanel createPanel;
	
	protected MetadataConfigLazyView view;

	/**
	 * Tab creation
	 * @param view	Reference to MetadaConfigLazyView - the parent class
	 */
	protected MetadataConfigTab(MetadataConfigLazyView view) {
		this.view = view;
		createController();

		panel = new SimpleContainer();
		table = createTable();	//Add list table to list panel

		createPanel = new VerticalPanel();
		createPanel.addStyleName(TAB_CONTAINERPANEL_STYLE);
		
		initWidget(panel);
		
		showListPanel();
	}
	
	public void showListPanel() {
		panel.setWidget(table);
		view.showListViewButtons();
	}
	
	public void showCreatePanel() {
		panel.setWidget(createPanel);
		view.showManageViewButtons();
	}
	
	public void deleteSelected() {
		List<R> selectedIds = table.getSelectedRecords();
		if(selectedIds.isEmpty()) {
			setWarning(constants.nothingToDelete());
			return;
		}
		clearErrors();
		if (controller != null) {
			delete(selectedIds);
		}
	}

	/**
	 * Getter for view
	 * @return Reference to the Lazy View
	 */
	public MetadataConfigLazyView getView() {
		return view;
	}

	/**
	 * Setter for view
	 * @param view	new value of the lazy view
	 */
	public void setView(MetadataConfigLazyView view) {
		this.view = view;
	}
	
	protected IMetadataConfigController<E> getController() {
		return controller;
	}

	public void setError(String message) {
		view.setError(message);
	}
	
	public void setWarning(String warning) {
		view.setWarning(warning);
	}
	
	/**
	 * Clears the errors/warnings displayed in List as well as Create sections
	 */
	public void clearErrors() {
		view.clearErrors();
	}
	
	/**
	 * Causes a data refresh on the tab. All errors/warnings are cleared, List section gets data from server, Create section gets cleared out.
	 */
	public void refresh() {
		clearErrors();
		table.refresh();
		refreshCreateView(null);
		showListPanel();
	}

	/**
	 * Getter for table widget contained inside the list panel
	 * @return	table
	 */
	public Table<K, R> getTable() {
		return table;
	}
	
	/**
	 * A utils method to convert the list of Ids into Comma Separated List
	 * @param itemIds
	 * @return
	 */
	public String getCommaSeparatedList(List<String> itemIds) {
		StringBuffer retVal = new StringBuffer("");
		for (int i=0; i<itemIds.size(); i++) {
			if (i > 0) {
				retVal.append(", ");
			}
			retVal.append(itemIds.get(i));
		}
		return retVal.toString();
	}
	
	/**
	 * Used for data input validations on client side 
	 * @param str
	 * @return
	 */
	protected boolean isBlank(String str) {
		if (str == null || str.trim().length() == 0)
			return true;
		return false;
	}
	
	public final String getTabName() {
		return tabName;
	}

	public void setTabName(String tabName) {
		this.tabName = tabName;
	}
	
	/**
	 * Implement this method to create appropriate type of controller in the sub classes
	 */
	protected abstract void createController();

	/**
	 * Create appropriate type of table instance in the sub class so that list panel can include it
	 * @return
	 */
	protected abstract Table<K, R> createTable();
	
	//dynamically update the create view from rpc
	//If item is null, show blank inputs
	/**
	 * Allows caller (rpc) to refresh the Create section. If supplied item is null, entry boxes are cleared from screen, else are populated with item attributes 
	 */
	public abstract void refreshCreateView(E item);
	
	/**
	 * Deletes items related to the given ids. Matching items are found based on primary key.
	 * @param selectedIds
	 */
	public abstract void delete(List<R> selectedIds);

	/**
	 * Saves the current item.
	 */
	public abstract void save();

}
