package com.tandbergtv.cms.portal.content.client.metadataconfig.service;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiAppType;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * App Type Configuration Service dedicated for the 'App Type' tab on Metadata Configuration UI 
 */
@RemoteServiceRelativePath("service/content/metadataconfig/UiAppTypeConfigService")
public interface UiAppTypeConfigService extends RemoteService {
	public String RELATIVE_PATH = "service/content/metadataconfig/UiAppTypeConfigService";
	
	/**
	 * Getter for App Type
	 * @param appType <String> The App Type key(primary key) value to look up the records
	 * @return <AppType> instance found against the provided appType key.
	 * @throws NeptuneException
	 */
	public UiAppType getAppType(String appType) throws NeptuneException;

	/**
	 * Creates or updates the App Type record
	 * @param appType <AppType> the updated AppType to be synchronized 
	 * @return <AppType> the updated <AppType> populated from the database
	 * @throws NeptuneException
	 */
	public UiAppType updateAppType(UiAppType appType) throws NeptuneException;

	/**
	 * Deletes all AppType records found to be connected to provided appTypes 
	 * @param appTypes List<String> the appType keys (primary keys) of App Types that need to be deleted
	 * @return <Boolean> true if all deletes went successful.
	 * @throws NeptuneException
	 */
	public Boolean deleteAppType(List<String> appTypes) throws NeptuneException;
	
	/**
	 * Getter for all App Types defined in the system as a list.
	 * @param sortColumn	<String> the column to be used for sorting. Pass null for sorting by appType. Other valid options are: notes
	 * @param descending	<Boolean> false for ascending, true for descending 
	 * @return List<AppType> containing all AppTypes available in the system 
	 * @throws NeptuneException
	 */
	public List<UiAppType> getAllAppTypes(String sortColumn, Boolean descending) throws NeptuneException;

}
