package com.tandbergtv.cms.portal.content.client.metadataconfig.service;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiContentAdvisory;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Content Advisory Configuration Service dedicated for the 'Content Advisory' tab on Metadata Configuration UI 
 */
@RemoteServiceRelativePath("service/content/metadataconfig/UiContentAdvisoryConfigService")
public interface UiContentAdvisoryConfigService extends RemoteService {
	public String RELATIVE_PATH = "service/content/metadataconfig/UiContentAdvisoryConfigService";
	
	/**
	 * Getter for Content Advisory
	 * @param contentAdvisory <String> The Content Advisory key(primary key) value to look up the records
	 * @return <ContentAdvisory> instance found against the provided contentAdvisory key.
	 * @throws NeptuneException
	 */
	public UiContentAdvisory getContentAdvisory(String contentAdvisory) throws NeptuneException;
	
	/**
	 * Creates or updates the Content Advisory record
	 * @param contentAdvisory <ContentAdvisory> the updated ContentAdvisory to be synchronized 
	 * @return <ContentAdvisory> the updated <ContentAdvisory> populated from the database
	 * @throws NeptuneException
	 */	
	public UiContentAdvisory updateContentAdvisory(UiContentAdvisory contentAdvisory) throws NeptuneException;

	/**
	 * Deletes all ContentAdvisory records found to be connected to provided contentAdvisories 
	 * @param contentAdvisories List<String> the contentAdvisory keys (primary keys) of Content Advisories that need to be deleted
	 * @return <Boolean> true if all deletes went successful.
	 * @throws NeptuneException
	 */
	public Boolean deleteContentAdvsory(List<String> contentAdvisories) throws NeptuneException;
	
	/**
	 * Getter for all Content Advisories defined in the system as a list.
	 * @param sortColumn	<String> the column to be used for sorting. Pass null for default sorting by advisory. Other valid options are: description
	 * @param descending	<Boolean> false for ascending, true for descending 
	 * @return List<ContentAdvisory> containing all ContentAdvisories available in the system 
	 * @throws NeptuneException
	 */
	public List<UiContentAdvisory> getAllContentAdvisories(String sortColumn, Boolean descending) throws NeptuneException;

}
