package com.tandbergtv.cms.portal.content.client.metadataconfig.service;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiGenre;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Genre Configuration Service dedicated for the 'Content Advisory' tab on Metadata Configuration UI 
 */
@RemoteServiceRelativePath("service/content/metadataconfig/UiGenreConfigService")
public interface UiGenreConfigService extends RemoteService {
	public String RELATIVE_PATH = "service/content/metadataconfig/UiGenreConfigService";
	
	/**
	 * Getter for Genre
	 * @param genre <String> The Genre key(primary key) value to look up the records
	 * @return <Genre> instance found against the provided genre key.
	 * @throws NeptuneException
	 */
	public UiGenre getGenre(String genre) throws NeptuneException;

	/**
	 * Creates or updates the Genre record
	 * @param genre <Genre> the updated Genre to be synchronized 
	 * @return <Genre> the updated <Genre> populated from the database
	 * @throws NeptuneException
	 */
	public UiGenre updateGenre(UiGenre genre) throws NeptuneException;

	/**
	 * Deletes all Genre records found to be connected to provided genres 
	 * @param genres List<String> the genre keys (primary keys) of Genres that need to be deleted
	 * @return <Boolean> true if all deletes went successful.
	 * @throws NeptuneException
	 */
	public Boolean deleteGenre(List<String> genres) throws NeptuneException;
	
	/**
	 * Getter for all Content Genres defined in the system as a list.
	 * @param sortColumn	<String> the column to be used for sorting. Pass null for default sorting by genre. Other valid options are: description
	 * @param descending	<Boolean> false for ascending, true for descending 
	 * @return List<Genre> containing all Genres available in the system 
	 * @throws NeptuneException
	 */
	public List<UiGenre> getAllGenre(String sortColumn, Boolean descending) throws NeptuneException;

}
