package com.tandbergtv.cms.portal.content.client.metadataconfig.service;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiProduct;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/content/metadataconfig/UiProductConfigService")
public interface UiProductConfigService extends RemoteService {
	public String RELATIVE_PATH = "service/content/metadataconfig/UiProductConfigService";
	
	/**
	 * Getter for Product
	 * @param productCode <String> The Product Code key(primary key) value to look up the records
	 * @return <Product> instance found against the provided productCode key.
	 * @throws NeptuneException
	 */
	public UiProduct getProduct(String productCode) throws NeptuneException;

	/**
	 * Creates or updates the Product record
	 * @param product <Product> the updated Product to be synchronized 
	 * @return <Product> the updated <Product> populated from the database
	 * @throws NeptuneException
	 */
	public UiProduct updateProduct(UiProduct product) throws NeptuneException;

	/**
	 * Deletes all Product records found to be connected to provided Product Codes 
	 * @param productCodes List<String> the product code keys (primary keys) of Products that need to be deleted
	 * @return <Boolean> true if all deletes went successful.
	 * @throws NeptuneException
	 */
	public Boolean deleteProduct(List<String> productCodes) throws NeptuneException;
	
	/**
	 * Getter for all Content Products defined in the system as a list.
	 * @param sortColumn	<String> the column to be used for sorting. Pass null for default sorting by productCode. Other valid options are: description
	 * @param descending	<Boolean> false for ascending, true for descending 
	 * @return List<Product> containing all Products available in the system 
	 * @throws NeptuneException
	 */
	public List<UiProduct> getAllProducts(String sortColumn, Boolean descending) throws NeptuneException;

}
