package com.tandbergtv.cms.portal.content.client.metadataconfig.service;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiRating;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/content/metadataconfig/UiRatingConfigService")
public interface UiRatingConfigService extends RemoteService {
	public String RELATIVE_PATH = "service/content/metadataconfig/UiRatingConfigService";
	
	/**
	 * Getter for Rating
	 * @param rating <String> Rating key (part of primary key) value to look up the records
	 * @param ratingSystem <String> Rating System key (part of primary key) value to look up the records
	 * @return <Rating> instance found against the provided rating and ratingSystem combination.
	 * @throws NeptuneException
	 */
	public UiRating getRating(String rating, String ratingSystem) throws NeptuneException;

	/**
	 * Creates or updates the Rating record
	 * @param rating <Rating> the updated Rating to be synchronized 
	 * @return <Rating> the updated <Rating> populated from the database
	 * @throws NeptuneException
	 */
	public UiRating updateRating(UiRating rating) throws NeptuneException;

	/**
	 * Deletes all Ratings records found to be connected to provided ratings 
	 * @param ratings Map<String, String> the rating and related rating system keys (primary keys) of Ratings that need to be deleted
	 * @return <Boolean> true if all deletes went successful.
	 * @throws NeptuneException
	 */
	public Boolean deleteRating(Map<String, String> ratings) throws NeptuneException;
	
	/**
	 * Getter for all Content Ratings defined in the system as a list.
	 * @param sortColumn	<String> the column to be used for sorting. Pass null for default sorting by ratings followed by ratingSystem. Other valid options are: rating, ratingSystem, description
	 * @param descending	<Boolean> false for ascending, true for descending 
	 * @return List<Rating> containing all Ratings available in the system 
	 * @throws NeptuneException
	 */
	public List<UiRating> getAllRatings(String sortColumn, Boolean descending) throws NeptuneException;
}
