package com.tandbergtv.cms.portal.content.client.metadataconfig.service;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiStudio;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/content/metadataconfig/UiStudioConfigService")
public interface UiStudioConfigService extends RemoteService {
	public String RELATIVE_PATH = "service/content/metadataconfig/UiStudioConfigService";
	
	/**
	 * Getter for Studio
	 * @param displayName <String> The Display Name key(primary key) value to look up the records
	 * @return <Studio> instance found against the provided displayName key.
	 * @throws NeptuneException
	 */
	public UiStudio getStudio(String displayName) throws NeptuneException;

	/**
	 * Creates or updates the Studio record
	 * @param studio <Studio> the updated Studio to be synchronized 
	 * @return <Studio> the updated <Studio> populated from the database
	 * @throws NeptuneException
	 */
	public UiStudio updateStudio(UiStudio studio) throws NeptuneException;

	/**
	 * Deletes all Studio records found to be connected to provided display names 
	 * @param displayNames List<String> the display name keys (primary keys) of Studio that need to be deleted
	 * @return <Boolean> true if all deletes went successful.
	 * @throws NeptuneException
	 */
	public Boolean deleteStuido(List<String> displayNames) throws NeptuneException;
	
	/**
	 * Getter for all Content Studios defined in the system as a list.
	 * @param sortColumn	<String> the column to be used for sorting. Pass null for default sorting by displayName. Other valid options are: organizationname, organizationcode, description
	 * @param descending	<Boolean> false for ascending, true for descending 
	 * @return List<Studio> containing all Studios available in the system 
	 * @throws NeptuneException
	 */	
	public List<UiStudio> getAllStudios(String sortColumn, Boolean descending) throws NeptuneException;
}
