package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiAppType;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiAppTypeConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiAppTypeConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class AppTypeConfigController implements IMetadataConfigController<UiAppType> {
	private UiAppTypeConfigServiceAsync service = GWT.create(UiAppTypeConfigService.class);
	private MetadataConfigTab<UiAppType, String, UiAppTypeRecord> tab;
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	public AppTypeConfigController(MetadataConfigTab<UiAppType, String, UiAppTypeRecord> tab) {
		this.tab = tab;
	}

	@Override
	public void getList() {
		tab.getTable().refresh();
	}

	@Override
	public void delete(final List<String> itemIds) {
		tab.getView().showBusyIndicator();

		service.deleteAppType(itemIds, new NeptuneAsyncCallback<Boolean>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.getView().hideBusyIndicator();
				tab.setError(caught.getMessage());
			}

			@Override
			public void onNeptuneSuccess(Boolean result) {
				tab.getView().hideBusyIndicator();
				if (result) {
					tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(myConstants.appTypeTabName(), tab.getCommaSeparatedList(itemIds)));
				} else {
					tab.setError(myConstants.deleteFailed());
					return;
				}
				getList();
			}
		});
	}

	@Override
	public void get(String... ids) {
		if (ids.length != 1) {
			//TODO: set error on UI
			return;
		}
		
		tab.getView().showBusyIndicator();
		
		service.getAppType(ids[0], new NeptuneAsyncCallback<UiAppType>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				//TODO: set error on UI
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiAppType result) {
				// TODO show contents on edit screen
				tab.getView().hideBusyIndicator();
			}
		});
	}

	@Override
	public void update(final UiAppType item) {
		tab.getView().showBusyIndicator();
		
		service.updateAppType(item, new NeptuneAsyncCallback<UiAppType>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.setError(caught.getMessage());
				tab.refreshCreateView(item);
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiAppType result) {
				tab.refreshCreateView(null);
				tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(myConstants.appTypeTabName(), item.getAppType()));
				tab.getView().hideBusyIndicator();
				getList();
				tab.showListPanel();
			}
		});
	}
}
