package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.i18n.client.HasDirection.Direction;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiAppType;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

public class AppTypeConfigTab extends MetadataConfigTab<UiAppType, String, UiAppTypeRecord> {
	
	private boolean createViewInitialized = false;
	private TextBox appTypeTxt = null;
	private TextArea notesTxt = null;
	
	public AppTypeConfigTab(MetadataConfigLazyView view) {
		super(view);
	}

	@Override
	protected void createController() {
		controller = new AppTypeConfigController(this);
	}

	@Override
	public void refreshCreateView(UiAppType item) {
		if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE)) {
			if (!createViewInitialized) {
				FormContainer form = new FormContainer(HorizontalAlignmentConstant.endOf(Direction.DEFAULT));
				appTypeTxt = new TextBox();
				appTypeTxt.addStyleName(TEXT_BOX_SHORT_STYLE);
				form.addRow(new LabelWidget(constants.atColumnHeadingAppType()), appTypeTxt, true);
				notesTxt = new TextArea();
				notesTxt.addStyleName(TEXT_AREA_STYLE);
				form.addRow(new LabelWidget(constants.atColumnHeadingNotes()), notesTxt, false);
				
				createPanel.add(form);
				createViewInitialized = true;
			}
			
			if (item == null) {
				appTypeTxt.setText("");
				notesTxt.setText("");
			} else {
				appTypeTxt.setText(item.getAppType() == null ? "" : item.getAppType());
				notesTxt.setText(item.getNotes() == null ? "" : item.getNotes());
			}
		}
	}

	public void save() {
		String err = validateInput();
		if (err.length() > 0) {
			setError(err);
			return;
		}
		clearErrors();
		if (controller != null) {
			UiAppType appType = new UiAppType();
			appType.setAppType(appTypeTxt.getText().trim());
			appType.setNotes(notesTxt.getText().trim());
			controller.update(appType);
		}
	}
	
	@Override
	protected Table<String, UiAppTypeRecord> createTable() {
		AppTypeDataProvider dataProvider = new AppTypeDataProvider(view, this);
		Table<String, UiAppTypeRecord> tbl = new Table<String, UiAppTypeRecord>(dataProvider);
		dataProvider.setTable(tbl);
		List<Column<?, UiAppTypeRecord>> columns = dataProvider.getColumns();
		SortFeature<String, UiAppTypeRecord> sortFeature = new SortFeatureImpl<String, UiAppTypeRecord>(columns.get(0), SortOrder.ASCENDING);
		sortFeature.getSortableColumns().addAll(columns);
		tbl.addSortFeature(sortFeature);
		tbl.initialize(null);
		return tbl;
	}

	@Override
	public void delete(List<UiAppTypeRecord> selectedIds) {
		if(Window.confirm(constants.confirmDelete())) {
			List<String> itemIds = new ArrayList<String>();
			for (UiAppTypeRecord id : selectedIds) {
				itemIds.add(id.getKey());
			}
			controller.delete(itemIds);
		}
	}

	//TODO: Check for special characters?
	private String validateInput() {
		String appType = appTypeTxt.getText();
		if (isBlank(appType)) {
			return constants.errBlankAppType();
		}
		if (appType.trim().length() > 64) {
			return constants.errAppTypeTooLong();
		}
		String notes = notesTxt.getText();
		if (!isBlank(notes) && notes.trim().length() > 255) {
			return constants.errNoteTooLong();
		}
		return "";
	}

}
