package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiAppType;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiAppTypeConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiAppTypeConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

/**
 * DataProvider for App Type table
 */
class AppTypeDataProvider implements DataProvider<String, UiAppTypeRecord> {
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	private UiAppTypeConfigServiceAsync service = GWT.create(UiAppTypeConfigService.class);
	private Table<String, UiAppTypeRecord> table;
	private List<Column<?, UiAppTypeRecord>> columns = null;
	private MetadataConfigLazyView view = null;
	
	private String lastColumnName = "";
	private SortOrder lastSortOrder = SortOrder.ASCENDING;

	private AppTypeConfigTab tab;
	
	public AppTypeDataProvider(MetadataConfigLazyView view, AppTypeConfigTab tab) {
		this.view = view;
		this.tab = tab;
	}
	
	@Override
	public List<Column<?, UiAppTypeRecord>> getColumns() {
		if (columns != null)
			return columns;
		
		columns = new ArrayList<Column<?,UiAppTypeRecord>>();
		
		columns.add(new ColumnBase<UiAppTypeRecord, UiAppTypeRecord>("APP_TYPE", myConstants.atColumnHeadingAppType()) {
			@Override
			public View<UiAppTypeRecord> getView(final UiAppTypeRecord record) {
				return new View<UiAppTypeRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getAppTypeDisplay());
						label.setTitle(record.getAppType().getAppType());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
				};
			}
		});
		
		columns.add(new ColumnBase<UiAppTypeRecord, UiAppTypeRecord>("NOTES", myConstants.atColumnHeadingNotes()){
			@Override
			public View<UiAppTypeRecord> getView(final UiAppTypeRecord record) {
				return new View<UiAppTypeRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getNotesDisplay());
						label.setTitle(record.getAppType().getNotes());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
					
				};
			}
		});
		
		return columns;
	}

	@Override
	public void getRecord(String key, AsyncCallback<UiAppTypeRecord> callback) {
		callback.onSuccess(null);
	}

	@Override
	public void getRecords(final AsyncCallback<List<UiAppTypeRecord>> callback) {
		String columnName = table.getSortFeature().getSortColumn().getName();
		SortOrder sortOrder = table.getSortFeature().getSortOrder();
		
		if (!columnName.equalsIgnoreCase(lastColumnName) || !sortOrder.equals(lastSortOrder)) {
			if (tab != null) {
				tab.clearErrors();
			}
		}
		lastColumnName = columnName;
		lastSortOrder = sortOrder;
		view.showBusyIndicator();
		
		service.getAllAppTypes(columnName, (sortOrder.equals(SortOrder.DESCENDING) ? true : false), new NeptuneAsyncCallback<List<UiAppType>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				if (tab != null) {
					tab.setError(caught.getMessage());
				}
//				callback.onFailure(caught);
				callback.onFailure(null);
				view.hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(List<UiAppType> result) {
				callback.onSuccess(convertRecords(result));
				view.hideBusyIndicator();
			}
		});
	}

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}

	private List<UiAppTypeRecord> convertRecords(List<UiAppType> results) {
		List<UiAppTypeRecord> retVal = new ArrayList<UiAppTypeRecord>();
		for (UiAppType item : results) {
			retVal.add(new UiAppTypeRecord(item));
		}
		return retVal;
	}

	public void setTable(Table<String, UiAppTypeRecord> table) {
		this.table = table;
	}
}
