package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype;

import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiAppType;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record wrapper for <UiAppType>
 * The ...Display() methods are used to make sure the data displayed in table columns does not exceed a predefined length. 
 * Data exceeding limit is chopped off and shown as a continuation mark '...' at the end. A tool tip displays complete data.
 */
public class UiAppTypeRecord implements Record<String> {
	private final UiAppType appType;
	
	public UiAppTypeRecord(UiAppType appType) {
		this.appType = appType;
	}
	
	@Override
	public String getKey() {
		return appType.getAppType();
	}

	public UiAppType getAppType() {
		return appType;
	}

	public String getAppTypeDisplay() {
		String retVal = appType.getAppType();
		if (retVal != null && retVal.length() > MetadataConfigConstants.ID_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.ID_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
	
	public String getNotesDisplay() {
		String retVal = appType.getNotes();
		if (retVal != null && retVal.length() > MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
}
