package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiContentAdvisory;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiContentAdvisoryConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiContentAdvisoryConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class ContentAdvisoryConfigController implements IMetadataConfigController<UiContentAdvisory>{
	private UiContentAdvisoryConfigServiceAsync service = GWT.create(UiContentAdvisoryConfigService.class);
	private MetadataConfigTab<UiContentAdvisory, String, UiContentAdvisoryRecord> tab;
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	public ContentAdvisoryConfigController(MetadataConfigTab<UiContentAdvisory, String, UiContentAdvisoryRecord> tab) {
		this.tab = tab;
	}
	
	@Override
	public void getList() {
		tab.getTable().refresh();
	}

	@Override
	public void delete(final List<String> itemIds) {
		tab.getView().showBusyIndicator();

		service.deleteContentAdvsory(itemIds, new NeptuneAsyncCallback<Boolean>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.getView().hideBusyIndicator();
				tab.setError(caught.getMessage());
			}

			@Override
			public void onNeptuneSuccess(Boolean result) {
				tab.getView().hideBusyIndicator();
				if (result) {
					tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(myConstants.contentAdvisoryTabName(), tab.getCommaSeparatedList(itemIds)));
				} else {
					tab.setError(myConstants.deleteFailed());
					return;
				}
				getList();
			}
		});
	}

	@Override
	public void get(String... ids) {
		if (ids.length != 1) {
			//TODO: set error on UI
			return;
		}

		tab.getView().showBusyIndicator();
		
		service.getContentAdvisory(ids[0], new NeptuneAsyncCallback<UiContentAdvisory>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				//TODO: set error on UI
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiContentAdvisory result) {
				// TODO show contents on edit screen
				tab.getView().hideBusyIndicator();
			}
		});
	}

	@Override
	public void update(final UiContentAdvisory item) {
		tab.getView().showBusyIndicator();
		
		service.updateContentAdvisory(item, new NeptuneAsyncCallback<UiContentAdvisory>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.setError(caught.getMessage());
				tab.refreshCreateView(item);
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiContentAdvisory result) {
				tab.refreshCreateView(null);
				tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(myConstants.contentAdvisoryTabName(), item.getContentAdvisory()));
				tab.getView().hideBusyIndicator();
				getList();
				tab.showListPanel();
			}
		});
	}
}
