package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.i18n.client.HasDirection.Direction;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiContentAdvisory;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

public class ContentAdvisoryConfigTab extends MetadataConfigTab<UiContentAdvisory, String, UiContentAdvisoryRecord> {
	
	private boolean createViewInitialized = false;
	private TextBox advisoryTxt = null;
	private TextArea descriptionTxt = null;
	
	public ContentAdvisoryConfigTab(MetadataConfigLazyView view) {
		super(view);
	}

	@Override
	protected void createController() {
		controller = new ContentAdvisoryConfigController(this);
	}

	@Override
	public void refreshCreateView(UiContentAdvisory item) {
		if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE)) {
			if (!createViewInitialized) {
				FormContainer form = new FormContainer(HorizontalAlignmentConstant.endOf(Direction.DEFAULT));
				advisoryTxt = new TextBox();
				advisoryTxt.addStyleName(TEXT_BOX_SHORT_STYLE);
				form.addRow(new LabelWidget(constants.caColumnHeadingContentAdvisory()), advisoryTxt, true);
				descriptionTxt = new TextArea();
				descriptionTxt.addStyleName(TEXT_AREA_STYLE);
				form.addRow(new LabelWidget(constants.caColumnHeadingDescription()), descriptionTxt, false);
				createPanel.add(form);
				createViewInitialized = true;
			}
			
			if (item == null) {
				advisoryTxt.setText("");
				descriptionTxt.setText("");
			} else {
				advisoryTxt.setText(item.getContentAdvisory() == null ? "" : item.getContentAdvisory());
				descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
			}
		}
	}

	@Override
	protected Table<String, UiContentAdvisoryRecord> createTable() {
		ContentAdvisoryDataProvider dataProvider = new ContentAdvisoryDataProvider(view, this);
		Table<String, UiContentAdvisoryRecord> tbl = new Table<String, UiContentAdvisoryRecord>(dataProvider);
		dataProvider.setTable(tbl);
		List<Column<?, UiContentAdvisoryRecord>> columns = dataProvider.getColumns();
		SortFeature<String, UiContentAdvisoryRecord> sortFeature = new SortFeatureImpl<String, UiContentAdvisoryRecord>(columns.get(0), SortOrder.ASCENDING);
		sortFeature.getSortableColumns().addAll(columns);
		tbl.addSortFeature(sortFeature);
		tbl.initialize(null);
		return tbl;
	}

	@Override
	public void delete(List<UiContentAdvisoryRecord> selectedIds) {
		if(Window.confirm(constants.confirmDelete())) {
			List<String> itemIds = new ArrayList<String>();
			for (UiContentAdvisoryRecord id : selectedIds) {
				itemIds.add(id.getKey());
			}
			controller.delete(itemIds);
		}
	}
	
	private String validateInput() {
		String advisory = advisoryTxt.getText();
		if (isBlank(advisory)) {
			return constants.errBlankAdvisory();
		}
		if (advisory.trim().length() > 64) {
			return constants.errAdvisoryTooLong();
		}
		String description = descriptionTxt.getText();
		if (!isBlank(description) && description.trim().length() > 255) {
			return constants.errDescriptionTooLong();
		}
		return "";
	}

	@Override
	public void save() {
		String err = validateInput();
		if (err.length() > 0) {
			setError(err);
			return;
		}
		clearErrors();
		if (controller != null) {
			UiContentAdvisory ca = new UiContentAdvisory();
			ca.setContentAdvisory(advisoryTxt.getText().trim());
			ca.setDescription(descriptionTxt.getText().trim());
			controller.update(ca);
		}
	}

}
